/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelN
extends AMQChannel
implements Channel {
    private static final String UNSPECIFIED_OUT_OF_BAND = "";
    public static final int CLOSING_TIMEOUT = 10000;
    public final Map<String, Consumer> _consumers = Collections.synchronizedMap(new HashMap());
    public volatile ReturnListener returnListener = null;

    public ChannelN(AMQConnection connection, int channelNumber) {
        super(connection, channelNumber);
    }

    public void open() throws IOException {
        AMQImpl.Channel.OpenOk openOk = (AMQImpl.Channel.OpenOk)this.exnWrappingRpc(new AMQImpl.Channel.Open(UNSPECIFIED_OUT_OF_BAND)).getMethod();
        Utility.use(openOk);
    }

    @Override
    public ReturnListener getReturnListener() {
        return this.returnListener;
    }

    @Override
    public void setReturnListener(ReturnListener listener) {
        this.returnListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastShutdownSignal(ShutdownSignalException signal) {
        HashMap<String, Consumer> snapshotConsumers;
        Map<String, Consumer> map = this._consumers;
        synchronized (map) {
            snapshotConsumers = new HashMap<String, Consumer>(this._consumers);
        }
        for (Map.Entry entry : snapshotConsumers.entrySet()) {
            Consumer callback = (Consumer)entry.getValue();
            try {
                callback.handleShutdownSignal((String)entry.getKey(), signal);
            }
            catch (Throwable ex) {
                this._connection.getExceptionHandler().handleConsumerException(this, ex, callback, (String)entry.getKey(), "handleShutdownSignal");
            }
        }
    }

    @Override
    public void processShutdownSignal(ShutdownSignalException signal) {
        super.processShutdownSignal(signal);
        this.broadcastShutdownSignal(signal);
    }

    public void releaseChannelNumber() {
        this._connection.disconnectChannel(this._channelNumber);
    }

    @Override
    public boolean processAsync(Command command) throws IOException {
        Method method = command.getMethod();
        if (this.isOpen()) {
            if (method instanceof AMQImpl.Basic.Deliver) {
                AMQImpl.Basic.Deliver m = (AMQImpl.Basic.Deliver)method;
                Consumer callback = this._consumers.get(m.consumerTag);
                if (callback == null) {
                    throw new UnsupportedOperationException("FIXME unsolicited delivery");
                }
                Envelope envelope = new Envelope(m.deliveryTag, m.redelivered, m.exchange, m.routingKey);
                try {
                    callback.handleDelivery(m.consumerTag, envelope, (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
                }
                catch (Throwable ex) {
                    this._connection.getExceptionHandler().handleConsumerException(this, ex, callback, m.consumerTag, "handleDelivery");
                }
                return true;
            }
            if (method instanceof AMQImpl.Basic.Return) {
                ReturnListener l = this.getReturnListener();
                if (l != null) {
                    AMQImpl.Basic.Return basicReturn = (AMQImpl.Basic.Return)method;
                    try {
                        l.handleBasicReturn(basicReturn.replyCode, basicReturn.replyText, basicReturn.exchange, basicReturn.routingKey, (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
                    }
                    catch (Throwable ex) {
                        this._connection.getExceptionHandler().handleReturnListenerException(this, ex);
                    }
                }
                return true;
            }
            if (method instanceof AMQImpl.Channel.Close) {
                this.transmit(new AMQImpl.Channel.CloseOk());
                this.releaseChannelNumber();
                ShutdownSignalException signal = new ShutdownSignalException(false, false, command);
                this.processShutdownSignal(signal);
                return true;
            }
            return false;
        }
        return !(method instanceof AMQImpl.Channel.CloseOk);
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, true, null);
    }

    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause) throws IOException {
        AMQImpl.Channel.Close reason = new AMQImpl.Channel.Close(closeCode, closeMessage, 0, 0);
        ShutdownSignalException signal = new ShutdownSignalException(false, initiatedByApplication, reason);
        if (cause != null) {
            signal.initCause(cause);
        }
        this.processShutdownSignal(signal);
        try {
            this.quiescingRpc(reason, 10000, new AMQCommand(new AMQImpl.Channel.CloseOk()));
        }
        catch (ShutdownSignalException sse) {
            // empty catch block
        }
        this.releaseChannelNumber();
    }

    @Override
    public int accessRequest(String realm) throws IOException {
        return this.accessRequest(realm, false, true, true, true, true);
    }

    @Override
    public int accessRequest(String realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) throws IOException {
        return this.getConnection().getParameters().getSuppressAccessRequest() ? 0 : ((AMQImpl.Access.RequestOk)this.exnWrappingRpc((Method)new AMQImpl.Access.Request((String)realm, (boolean)exclusive, (boolean)passive, (boolean)active, (boolean)write, (boolean)read)).getMethod()).ticket;
    }

    @Override
    public void basicPublish(int ticket, String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.basicPublish(ticket, exchange, routingKey, false, false, props, body);
    }

    @Override
    public void basicPublish(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        AMQP.BasicProperties useProps = props;
        if (props == null) {
            useProps = MessageProperties.MINIMAL_BASIC;
        }
        AMQImpl.Basic.Publish publish = new AMQImpl.Basic.Publish(ticket, exchange, routingKey, mandatory, immediate);
        AMQCommand command = new AMQCommand(publish, useProps, body);
        command.transmit(this);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(int ticket, String exchange, String type, boolean passive, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQImpl.Exchange.Declare(ticket, exchange, type, passive, durable, autoDelete, false, false, arguments)).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(int ticket, String exchange, String type, boolean durable) throws IOException {
        return this.exchangeDeclare(ticket, exchange, type, false, durable, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(int ticket, String exchange, String type) throws IOException {
        return this.exchangeDeclare(ticket, exchange, type, false, false, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(int ticket, String exchange, boolean ifUnused) throws IOException {
        return (AMQImpl.Exchange.DeleteOk)this.exnWrappingRpc(new AMQImpl.Exchange.Delete(ticket, exchange, ifUnused, false)).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(int ticket, String exchange) throws IOException {
        return this.exchangeDelete(ticket, exchange, false);
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclare(int ticket, String queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQImpl.Queue.Declare(ticket, queue, passive, durable, exclusive, autoDelete, false, arguments)).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclare(int ticket, String queue, boolean durable) throws IOException {
        return this.queueDeclare(ticket, queue, false, durable, false, false, (Map)null);
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclare(int ticket, String queue) throws IOException {
        return this.queueDeclare(ticket, queue, false, false, false, false, (Map)null);
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare(int ticket) throws IOException {
        return this.queueDeclare(ticket, UNSPECIFIED_OUT_OF_BAND, false, false, true, true, (Map)null);
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(int ticket, String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        return (AMQImpl.Queue.DeleteOk)this.exnWrappingRpc(new AMQImpl.Queue.Delete(ticket, queue, ifUnused, ifEmpty, false)).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(int ticket, String queue) throws IOException {
        return this.queueDelete(ticket, queue, false, false);
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(int ticket, String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.BindOk)this.exnWrappingRpc(new AMQImpl.Queue.Bind(ticket, queue, exchange, routingKey, false, arguments)).getMethod();
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(int ticket, String queue, String exchange, String routingKey) throws IOException {
        return this.queueBind(ticket, queue, exchange, routingKey, (Map)null);
    }

    @Override
    public GetResponse basicGet(int ticket, String queue, boolean noAck) throws IOException {
        AMQCommand replyCommand = this.exnWrappingRpc(new AMQImpl.Basic.Get(ticket, queue, noAck));
        Method method = replyCommand.getMethod();
        if (method instanceof AMQImpl.Basic.GetOk) {
            AMQImpl.Basic.GetOk getOk = (AMQImpl.Basic.GetOk)method;
            Envelope envelope = new Envelope(getOk.deliveryTag, getOk.redelivered, getOk.exchange, getOk.routingKey);
            AMQP.BasicProperties props = (AMQP.BasicProperties)replyCommand.getContentHeader();
            byte[] body = replyCommand.getContentBody();
            int messageCount = getOk.messageCount;
            return new GetResponse(envelope, props, body, messageCount);
        }
        if (method instanceof AMQImpl.Basic.GetEmpty) {
            return null;
        }
        throw new UnexpectedMethodError(method);
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.transmit(new AMQImpl.Basic.Ack(deliveryTag, multiple));
    }

    @Override
    public String basicConsume(int ticket, String queue, Consumer callback) throws IOException {
        return this.basicConsume(ticket, queue, false, callback);
    }

    @Override
    public String basicConsume(int ticket, String queue, boolean noAck, Consumer callback) throws IOException {
        return this.basicConsume(ticket, queue, noAck, UNSPECIFIED_OUT_OF_BAND, callback);
    }

    @Override
    public String basicConsume(int ticket, String queue, boolean noAck, String consumerTag, Consumer callback) throws IOException {
        return this.basicConsume(ticket, queue, noAck, consumerTag, false, false, callback);
    }

    @Override
    public String basicConsume(int ticket, String queue, boolean noAck, String consumerTag, boolean noLocal, boolean exclusive, final Consumer callback) throws IOException {
        AMQChannel.BlockingRpcContinuation<String> k = new AMQChannel.BlockingRpcContinuation<String>(){

            @Override
            public String transformReply(AMQCommand replyCommand) {
                String actualConsumerTag = ((AMQImpl.Basic.ConsumeOk)replyCommand.getMethod()).consumerTag;
                ChannelN.this._consumers.put(actualConsumerTag, callback);
                try {
                    callback.handleConsumeOk(actualConsumerTag);
                }
                catch (Throwable ex) {
                    ChannelN.this._connection.getExceptionHandler().handleConsumerException(ChannelN.this, ex, callback, actualConsumerTag, "handleConsumeOk");
                }
                return actualConsumerTag;
            }
        };
        this.rpc(new AMQImpl.Basic.Consume(ticket, queue, consumerTag, noLocal, noAck, exclusive, false), k);
        try {
            return (String)k.getReply();
        }
        catch (ShutdownSignalException ex) {
            throw ChannelN.wrap(ex);
        }
    }

    @Override
    public void basicCancel(final String consumerTag) throws IOException {
        AMQChannel.BlockingRpcContinuation<Consumer> k = new AMQChannel.BlockingRpcContinuation<Consumer>(){

            @Override
            public Consumer transformReply(AMQCommand replyCommand) {
                AMQImpl.Basic.CancelOk dummy = (AMQImpl.Basic.CancelOk)replyCommand.getMethod();
                Utility.use(dummy);
                Consumer callback = ChannelN.this._consumers.remove(consumerTag);
                try {
                    callback.handleCancelOk(consumerTag);
                }
                catch (Throwable ex) {
                    ChannelN.this._connection.getExceptionHandler().handleConsumerException(ChannelN.this, ex, callback, consumerTag, "handleCancelOk");
                }
                return callback;
            }
        };
        this.rpc(new AMQImpl.Basic.Cancel(consumerTag, false), k);
        try {
            Consumer callback = (Consumer)k.getReply();
            Utility.use(callback);
        }
        catch (ShutdownSignalException ex) {
            throw ChannelN.wrap(ex);
        }
    }

    @Override
    public AMQImpl.Tx.SelectOk txSelect() throws IOException {
        return (AMQImpl.Tx.SelectOk)this.exnWrappingRpc(new AMQImpl.Tx.Select()).getMethod();
    }

    @Override
    public AMQImpl.Tx.CommitOk txCommit() throws IOException {
        return (AMQImpl.Tx.CommitOk)this.exnWrappingRpc(new AMQImpl.Tx.Commit()).getMethod();
    }

    @Override
    public AMQImpl.Tx.RollbackOk txRollback() throws IOException {
        return (AMQImpl.Tx.RollbackOk)this.exnWrappingRpc(new AMQImpl.Tx.Rollback()).getMethod();
    }
}

