/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.pmd.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.rule.AbstractInefficientZeroCheck;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.util.StringUtil;

public final class UseStringIsEmptyRule
extends AbstractInefficientZeroCheck {
    public boolean appliesToClassName(String name) {
        return StringUtil.isSame((String)name, (String)"String", (boolean)true, (boolean)true, (boolean)true);
    }

    public Map<String, List<String>> getComparisonTargets() {
        HashMap<String, List<String>> rules = new HashMap<String, List<String>>();
        rules.put("<", Arrays.asList("1"));
        rules.put(">", Arrays.asList("0"));
        rules.put("==", Arrays.asList("0"));
        rules.put("!=", Arrays.asList("0"));
        rules.put(">=", Arrays.asList("0", "1"));
        rules.put("<=", Arrays.asList("0"));
        return rules;
    }

    public boolean isTargetMethod(JavaNameOccurrence occ) {
        boolean target = false;
        if (occ.getNameForWhichThisIsAQualifier() != null && occ.getLocation().getImage().endsWith(".length")) {
            target = true;
        }
        return target;
    }

    public Object visit(ASTPrimarySuffix node, Object data) {
        if (node.getImage() != null && node.getImage().endsWith("length")) {
            ASTClassOrInterfaceType type = UseStringIsEmptyRule.getTypeOfPrimaryPrefix(node);
            if (type == null) {
                type = UseStringIsEmptyRule.getTypeOfMethodCall(node);
            }
            if (type != null && this.appliesToClassName(type.getType().getSimpleName())) {
                this.checkNodeAndReport(data, (Node)node, node.jjtGetParent().jjtGetParent());
            }
        }
        return data;
    }

    private static ASTClassOrInterfaceType getTypeOfMethodCall(ASTPrimarySuffix node) {
        ASTClassOrInterfaceType type = null;
        ASTName method = (ASTName)((ASTPrimaryPrefix)node.jjtGetParent().getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class);
        if (method != null) {
            ClassScope scope = (ClassScope)node.getScope().getEnclosingScope(ClassScope.class);
            Map methods = scope.getMethodDeclarations();
            for (Map.Entry entry : methods.entrySet()) {
                if (!((MethodNameDeclaration)entry.getKey()).getName().equals(method.getImage())) continue;
                type = (ASTClassOrInterfaceType)((ASTResultType)((ASTMethodDeclaration)((MethodNameDeclaration)entry.getKey()).getNode().getFirstParentOfType(ASTMethodDeclaration.class)).getFirstChildOfType(ASTResultType.class)).getFirstDescendantOfType(ASTClassOrInterfaceType.class);
                break;
            }
        }
        return type;
    }

    private static ASTClassOrInterfaceType getTypeOfPrimaryPrefix(ASTPrimarySuffix node) {
        return (ASTClassOrInterfaceType)((ASTPrimaryPrefix)node.jjtGetParent().getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstDescendantOfType(ASTClassOrInterfaceType.class);
    }
}

