/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.pmd.rules;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.rule.junit.AbstractJUnitRule;

public final class ProhibitPlainJunitAssertionsRule
extends AbstractJUnitRule {
    private static final String[] PROHIBITED = new String[]{"org.junit.Assert.assert", "junit.framework.Assert.assert"};

    public Object visit(ASTMethodDeclaration method, Object data) {
        if (this.isJUnitMethod(method, data) && this.containsPlainJunitAssert((Node)method.getBlock())) {
            this.addViolation(data, (Node)method);
        }
        return data;
    }

    public Object visit(ASTImportDeclaration imp, Object data) {
        for (String element : PROHIBITED) {
            if (!imp.getImportedName().contains(element)) continue;
            this.addViolation(data, (Node)imp);
            break;
        }
        return super.visit(imp, data);
    }

    private boolean containsPlainJunitAssert(Node node) {
        boolean found = false;
        if (node instanceof ASTStatementExpression && ProhibitPlainJunitAssertionsRule.isPlainJunitAssert(node)) {
            found = true;
        }
        if (!found) {
            for (int iter = 0; iter < node.jjtGetNumChildren(); ++iter) {
                Node child = node.jjtGetChild(iter);
                if (!this.containsPlainJunitAssert(child)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private static boolean isPlainJunitAssert(Node statement) {
        ASTPrimaryExpression expression = ProhibitPlainJunitAssertionsRule.getChildNodeWithType(statement, ASTPrimaryExpression.class);
        ASTPrimaryPrefix prefix = ProhibitPlainJunitAssertionsRule.getChildNodeWithType((Node)expression, ASTPrimaryPrefix.class);
        ASTName name = ProhibitPlainJunitAssertionsRule.getChildNodeWithType((Node)prefix, ASTName.class);
        boolean assrt = false;
        if (name != null) {
            String img = name.getImage();
            assrt = img != null && (img.startsWith("assert") || img.startsWith("Assert.assert"));
        }
        return assrt;
    }

    private static <T extends Node> T getChildNodeWithType(Node node, Class<T> clazz) {
        Node expression = null;
        if (node != null && node.jjtGetNumChildren() > 0 && clazz.isInstance(node.jjtGetChild(0))) {
            expression = (Node)clazz.cast(node.jjtGetChild(0));
        }
        return (T)expression;
    }
}

