/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.pmd;

import com.jcabi.log.Logger;
import com.qulice.pmd.PmdListener;
import com.qulice.spi.Environment;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.util.datasource.DataSource;

final class SourceValidator {
    private final RuleContext context = new RuleContext();
    private final PmdListener listener;
    private final PMDConfiguration config;

    SourceValidator(Environment env) {
        this.listener = new PmdListener(env);
        this.config = new PMDConfiguration();
    }

    public Collection<RuleViolation> validate(Collection<DataSource> sources, String path) {
        this.config.setRuleSets("com/qulice/pmd/ruleset.xml");
        Report report = new Report();
        report.addListener((ReportListener)this.listener);
        this.context.setReport(report);
        for (DataSource source : sources) {
            String name = source.getNiceFileName(false, path);
            Logger.debug((Object)this, (String)"Processing file: %s", (Object[])new Object[]{name});
            this.context.setSourceCodeFilename(name);
            this.context.setSourceCodeFile(new File(name));
            this.validateOne(source);
        }
        return this.listener.getViolations();
    }

    private void validateOne(DataSource source) {
        RuleSetFactory factory = new RuleSetFactory();
        factory.setMinimumPriority(RulePriority.valueOf((int)5));
        PMD.processFiles((PMDConfiguration)this.config, (RuleSetFactory)factory, new LinkedList<DataSource>(Collections.singleton(source)), (RuleContext)this.context, Collections.emptyList());
    }
}

