/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.pmd;

import com.qulice.pmd.SourceValidator;
import com.qulice.spi.Environment;
import com.qulice.spi.ResourceValidator;
import com.qulice.spi.Violation;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.FileDataSource;

public final class PmdValidator
implements ResourceValidator {
    private final transient Environment env;

    public PmdValidator(Environment env) {
        this.env = env;
    }

    public Collection<Violation> validate(Collection<File> files) {
        SourceValidator validator = new SourceValidator(this.env);
        LinkedList<DataSource> sources = new LinkedList<DataSource>();
        for (File file : files) {
            sources.add((DataSource)new FileDataSource(file));
        }
        Collection<RuleViolation> breaches = validator.validate(sources, this.env.basedir().getPath());
        LinkedList<Violation> violations = new LinkedList<Violation>();
        for (RuleViolation breach : breaches) {
            violations.add((Violation)new Violation.Default(this.name(), breach.getRule().getName(), breach.getFilename(), String.format("%d-%d", breach.getBeginLine(), breach.getEndLine()), breach.getDescription()));
        }
        return violations;
    }

    public String name() {
        return "PMD";
    }
}

