/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.jcabi.log.Logger;
import com.qulice.maven.MavenEnvironment;
import com.qulice.maven.MavenValidator;
import com.qulice.spi.ValidationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.project.MavenProject;

public final class SvnPropertiesValidator
implements MavenValidator {
    @Override
    public void validate(MavenEnvironment env) throws ValidationException {
        if (SvnPropertiesValidator.isSvn(env.project())) {
            File dir = new File(env.project().getBasedir(), "src");
            if (dir.exists()) {
                this.validate(dir);
            } else {
                Logger.info((Object)this, (String)"%s directory is absent, no need to check SVN properties", (Object[])new Object[]{dir});
            }
        } else {
            Logger.info((Object)this, (String)"This is not an SVN project");
        }
    }

    private void validate(File dir) throws ValidationException {
        Collection files = FileUtils.listFiles((File)dir, (String[])new String[]{"java", "txt", "xsl", "xml", "html", "js", "css", "vm", "php", "py", "groovy", "ini", "properties", "bsh", "xsd", "sql"}, (boolean)true);
        int errors = 0;
        for (File file : files) {
            if (this.valid(file)) continue;
            ++errors;
        }
        if (errors != 0) {
            Logger.info((Object)this, (String)"%d of %d files don't have required SVN properties", (Object[])new Object[]{errors, files.size()});
            throw new ValidationException("%d files with invalid SVN properties", new Object[]{errors});
        }
        Logger.info((Object)this, (String)"%d text files have all required SVN properties", (Object[])new Object[]{files.size()});
    }

    private static boolean isSvn(MavenProject project) {
        return project.getScm() != null && project.getScm().getConnection() != null && project.getScm().getConnection().startsWith("scm:svn");
    }

    private boolean valid(File file) {
        String keywords;
        boolean valid = true;
        String style = SvnPropertiesValidator.propget(file, "svn:eol-style");
        if (!"native".equals(style)) {
            Logger.error((Object)this, (String)"File %s doesn't have 'svn:eol-style' set to 'native': '%s'", (Object[])new Object[]{file, style});
            valid = false;
        }
        if (!(keywords = SvnPropertiesValidator.propget(file, "svn:keywords")).contains("Id")) {
            Logger.error((Object)this, (String)"File %s doesn't have 'svn:keywords' with 'Id': '%s'", (Object[])new Object[]{file, keywords});
            valid = false;
        }
        return valid;
    }

    private static String propget(File file, String name) {
        ProcessBuilder builder = new ProcessBuilder("svn", "propget", name, file.getAbsolutePath());
        builder.redirectErrorStream(true);
        try {
            Process process = builder.start();
            process.waitFor();
            return IOUtils.toString((InputStream)process.getInputStream()).trim();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }
}

