/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.jcabi.log.Logger;
import com.qulice.maven.MavenEnvironment;
import com.qulice.maven.MavenValidator;
import com.qulice.spi.ValidationException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.ContextException;

final class DependenciesValidator
implements MavenValidator {
    private static final String SEP = "\n\t";

    DependenciesValidator() {
    }

    @Override
    public void validate(MavenEnvironment env) throws ValidationException {
        int failures;
        Collection used;
        Collection excludes = env.excludes("dependencies");
        if (!env.outdir().exists() || "pom".equals(env.project().getPackaging()) || excludes.contains(".*")) {
            Logger.info((Object)this, (String)"No dependency analysis in this project");
            return;
        }
        Collection unused = Collections2.filter(DependenciesValidator.unused(env), (Predicate)Predicates.not((Predicate)new ExcludePredicate(excludes)));
        if (!unused.isEmpty()) {
            Logger.warn((Object)this, (String)"Unused declared dependencies found:%s%s", (Object[])new Object[]{SEP, StringUtils.join((Iterable)unused, (String)SEP)});
        }
        if (!(used = Collections2.filter(DependenciesValidator.used(env), (Predicate)Predicates.not((Predicate)new ExcludePredicate(excludes)))).isEmpty()) {
            Logger.warn((Object)this, (String)"Used undeclared dependencies found:%s%s", (Object[])new Object[]{SEP, StringUtils.join((Iterable)used, (String)SEP)});
        }
        if ((failures = used.size() + unused.size()) > 0) {
            throw new ValidationException("%d dependency problem(s) found", new Object[]{failures});
        }
        Logger.info((Object)this, (String)"No dependency problems found");
    }

    private static ProjectDependencyAnalysis analyze(MavenEnvironment env) {
        try {
            return ((ProjectDependencyAnalyzer)((PlexusContainer)env.context().get((Object)"plexus")).lookup(ProjectDependencyAnalyzer.ROLE, "default")).analyze(env.project());
        }
        catch (ProjectDependencyAnalyzerException | ComponentLookupException | ContextException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Collection<String> used(MavenEnvironment env) {
        ProjectDependencyAnalysis analysis = DependenciesValidator.analyze(env);
        LinkedList<String> used = new LinkedList<String>();
        for (Object artifact : analysis.getUsedUndeclaredArtifacts()) {
            used.add(artifact.toString());
        }
        return used;
    }

    private static Collection<String> unused(MavenEnvironment env) {
        ProjectDependencyAnalysis analysis = DependenciesValidator.analyze(env);
        LinkedList<String> unused = new LinkedList<String>();
        for (Object obj : analysis.getUnusedDeclaredArtifacts()) {
            Artifact artifact = (Artifact)obj;
            if (!artifact.getScope().equals("compile")) continue;
            unused.add(artifact.toString());
        }
        return unused;
    }

    private static class ExcludePredicate
    implements Predicate<String> {
        private final Collection<String> excludes;

        ExcludePredicate(Collection<String> excludes) {
            this.excludes = excludes;
        }

        public boolean apply(String name) {
            boolean ignore = false;
            for (String exclude : this.excludes) {
                if (!name.startsWith(exclude)) continue;
                ignore = true;
                break;
            }
            return ignore;
        }
    }
}

