/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.jcabi.log.Logger;
import com.qulice.maven.AbstractQuliceMojo;
import com.qulice.maven.DefaultValidatorsProvider;
import com.qulice.maven.MavenEnvironment;
import com.qulice.maven.MavenValidator;
import com.qulice.maven.ValidatorsProvider;
import com.qulice.spi.Environment;
import com.qulice.spi.ResourceValidator;
import com.qulice.spi.ValidationException;
import com.qulice.spi.Validator;
import com.qulice.spi.Violation;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public final class CheckMojo
extends AbstractQuliceMojo {
    private ValidatorsProvider provider = new DefaultValidatorsProvider(this.env());

    @Override
    public void doExecute() throws MojoFailureException {
        try {
            this.run();
        }
        catch (ValidationException ex) {
            Logger.info((Object)((Object)this), (String)"Read our quality policy: http://www.qulice.com/quality.html");
            throw new MojoFailureException("Failure", (Throwable)ex);
        }
    }

    public void setValidatorsProvider(ValidatorsProvider prov) {
        this.provider = prov;
    }

    private void run() throws ValidationException {
        LinkedList results = new LinkedList();
        MavenEnvironment env = this.env();
        Collection files = env.files("*.*");
        if (!files.isEmpty()) {
            Collection<ResourceValidator> validators = this.provider.externalResource();
            for (ResourceValidator validator : validators) {
                results.addAll(validator.validate(CheckMojo.filter(env, files, validator)));
            }
            for (Violation result : results) {
                Logger.info((Object)((Object)this), (String)"%s: %s[%s]: %s (%s)", (Object[])new Object[]{result.validator(), StringUtils.removeStart((String)result.file(), (String)String.format("%s/", this.session().getExecutionRootDirectory())), result.lines(), result.message(), result.name()});
            }
        }
        if (!results.isEmpty()) {
            throw new ValidationException(String.format("There are %d violations", results.size()), new Object[0]);
        }
        for (Validator validator : this.provider.external()) {
            Logger.info((Object)((Object)this), (String)"Starting %s validator", (Object[])new Object[]{validator.name()});
            validator.validate((Environment)env);
            Logger.info((Object)((Object)this), (String)"Finishing %s validator", (Object[])new Object[]{validator.name()});
        }
        for (MavenValidator mavenValidator : this.provider.internal()) {
            mavenValidator.validate(env);
        }
    }

    private static Collection<File> filter(MavenEnvironment env, Collection<File> files, ResourceValidator validator) {
        LinkedList<File> filtered = new LinkedList<File>();
        for (File file : files) {
            if (env.exclude(validator.name().toLowerCase(Locale.ENGLISH), file.toString())) continue;
            filtered.add(file);
        }
        return filtered;
    }
}

