/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Map;

public final class MethodsOrderCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return new int[]{14, 154};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 154) {
            this.checkClass(ast);
        }
    }

    private void checkClass(DetailAST node) {
        DetailAST obj = node.findFirstToken(6);
        if (obj != null) {
            this.checkOrder(MethodsOrderCheck.findAllChildren(obj, 9));
        }
    }

    private void checkOrder(Iterable<DetailAST> methods) {
        Modifiers prev = Modifiers.PUB;
        for (DetailAST method : methods) {
            Modifiers mtype = MethodsOrderCheck.getModifierType(method);
            if (mtype.getOrder() < prev.getOrder()) {
                this.log(method.getLineNo(), "Wrong method declaration order", new Object[0]);
                continue;
            }
            prev = mtype;
        }
    }

    private static Modifiers getModifierType(DetailAST method) {
        DetailAST modifiers = method.findFirstToken(5);
        DetailAST modifier = (DetailAST)Optional.fromNullable((Object)modifiers.findFirstToken(Modifiers.PUB.getType())).or(Optional.fromNullable((Object)modifiers.findFirstToken(Modifiers.PROT.getType()))).or(Optional.fromNullable((Object)modifiers.findFirstToken(Modifiers.PRIV.getType()))).orNull();
        Modifiers mod = modifier == null ? Modifiers.DEF : Modifiers.getByType(modifier.getType());
        return mod;
    }

    private static Iterable<DetailAST> findAllChildren(DetailAST base, int type) {
        ArrayList children = Lists.newArrayList();
        for (DetailAST child = base.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != type) continue;
            children.add(child);
        }
        return children;
    }

    private static enum Modifiers {
        PUB(62, 1),
        PROT(63, 2),
        DEF(-1, 3),
        PRIV(61, 4);

        private static Map<Integer, Modifiers> mdos;
        private final Integer type;
        private final int order;

        private Modifiers(Integer typ, Integer ord) {
            this.type = typ;
            this.order = ord;
        }

        public static Modifiers getByType(int type) {
            return mdos.get(type);
        }

        public int getType() {
            return this.type;
        }

        public int getOrder() {
            return this.order;
        }

        static {
            mdos = ImmutableMap.builder().put((Object)PUB.getType(), (Object)PUB).put((Object)PROT.getType(), (Object)PROT).put((Object)-1, (Object)DEF).put((Object)PRIV.getType(), (Object)PRIV).build();
        }
    }
}

