/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.qulice.checkstyle.LineRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class LineRanges {
    private final LocalCollection lines = new LocalCollection();

    public void add(LineRange line) {
        this.lines.collection().add(line);
    }

    public Iterator<LineRange> iterator() {
        return this.lines.collection().iterator();
    }

    public boolean inRange(int line) {
        return !this.lines.collection().isEmpty() && FluentIterable.from(this.lines.collection()).anyMatch((Predicate)new LineWithAny(line));
    }

    public LineRanges within(LineRanges ranges) {
        LineRanges result = new LineRanges();
        Iterator<LineRange> iterator = ranges.iterator();
        while (iterator.hasNext()) {
            LineRange next = iterator.next();
            for (LineRange line : this.lines.collection()) {
                if (!next.within(line)) continue;
                result.add(line);
            }
        }
        return result;
    }

    public void clear() {
        this.lines.collection().clear();
    }

    private static final class LocalCollection
    extends ThreadLocal<Collection<LineRange>> {
        private final transient Collection<LineRange> ranges = new ArrayList<LineRange>(20);

        private LocalCollection() {
        }

        public Collection<LineRange> collection() {
            return this.ranges;
        }
    }

    private static final class LineWithAny
    implements Predicate<LineRange> {
        private final int given;

        private LineWithAny(int line) {
            this.given = line;
        }

        public boolean apply(LineRange range) {
            return range != null && range.within(this.given);
        }
    }
}

