/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class JavadocTagsCheck
extends AbstractCheck {
    private final Map<String, Pattern> tags = new HashMap<String, Pattern>();
    private final Collection<String> prohibited = Arrays.asList("author", "version");

    public int[] getDefaultTokens() {
        return new int[]{14, 15};
    }

    public void init() {
        this.tags.put("since", Pattern.compile("^\\d+(\\.\\d+){1,2}(\\.[0-9A-Za-z-]+(\\.[0-9A-Za-z-]+)*)?$"));
    }

    public void visitToken(DetailAST ast) {
        if (ast.getParent() == null) {
            String[] lines = this.getLines();
            int start = ast.getLineNo();
            int cstart = JavadocTagsCheck.findCommentStart(lines, start);
            int cend = JavadocTagsCheck.findCommentEnd(lines, start);
            if (cend > cstart && cstart >= 0) {
                for (String tag : this.prohibited) {
                    this.findProhibited(lines, start, cstart, cend, tag);
                }
                for (String tag : this.tags.keySet()) {
                    this.matchTagFormat(lines, cstart, cend, tag);
                }
            } else {
                this.log(0, "Problem finding class/interface comment", new Object[0]);
            }
        }
    }

    private static String getTagText(String line) {
        return line.substring(line.indexOf(32, line.indexOf(64)) + 1);
    }

    private static int findTrimmedTextUp(String[] lines, int start, String text) {
        int found = -1;
        for (int pos = start - 1; pos >= 0; --pos) {
            if (!lines[pos].trim().equals(text)) continue;
            found = pos;
            break;
        }
        return found;
    }

    private static int findCommentStart(String[] lines, int start) {
        return JavadocTagsCheck.findTrimmedTextUp(lines, start, "/**");
    }

    private static int findCommentEnd(String[] lines, int start) {
        return JavadocTagsCheck.findTrimmedTextUp(lines, start, "*/");
    }

    private void findProhibited(String[] lines, int start, int cstart, int cend, String tag) {
        List<Integer> found = this.findTagLineNum(lines, cstart, cend, tag);
        if (!found.isEmpty()) {
            this.log(start + 1, StringUtils.join((Object[])new String[]{"Prohibited ''@{0}'' tag in", " class/interface comment"}), new Object[]{tag});
        }
    }

    private void matchTagFormat(String[] lines, int start, int end, String tag) {
        List<Integer> found = this.findTagLineNum(lines, start, end, tag);
        if (found.isEmpty()) {
            this.log(start + 1, "Missing ''@{0}'' tag in class/interface comment", new Object[]{tag});
            return;
        }
        for (Integer item : found) {
            String text = JavadocTagsCheck.getTagText(lines[item]);
            if (this.tags.get(tag).matcher(text).matches()) continue;
            this.log(item + 1, "Tag text ''{0}'' does not match the pattern ''{1}''", new Object[]{text, this.tags.get(tag).toString()});
        }
    }

    private List<Integer> findTagLineNum(String[] lines, int start, int end, String tag) {
        String prefix = String.format(" * @%s ", tag);
        ArrayList<Integer> found = new ArrayList<Integer>(1);
        for (int pos = start; pos <= end; ++pos) {
            String line = lines[pos];
            if (!line.contains(String.format("@%s ", tag))) continue;
            if (!line.startsWith(prefix)) {
                this.log(start + pos + 1, "Line with ''@{0}'' does not start with a ''{1}''", new Object[]{tag, prefix});
                break;
            }
            found.add(pos);
        }
        return found;
    }
}

