/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class JavadocLocationCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 10, 8, 9};
    }

    public void visitToken(DetailAST ast) {
        if (JavadocLocationCheck.isField(ast)) {
            int current = ast.getLineNo();
            int end = JavadocLocationCheck.findCommentEnd(this.getLines(), current);
            if (end > JavadocLocationCheck.getCommentMinimum(ast)) {
                this.report(current, end);
            }
        }
    }

    private void report(int current, int end) {
        int diff = current - end;
        if (diff > 1) {
            for (int pos = 1; pos < diff; ++pos) {
                this.log(end + pos, "Empty line between javadoc and subject", new Object[0]);
            }
        }
    }

    private static int getCommentMinimum(DetailAST node) {
        int minimum = 0;
        DetailAST parent = node.getParent();
        if (null == parent) {
            DetailAST object;
            if (!JavadocLocationCheck.isFirst(node) && (object = node.getPreviousSibling().findFirstToken(6)) != null) {
                minimum = object.getLastChild().getLineNo();
            }
        } else {
            DetailAST previous = node.getPreviousSibling();
            if (null == previous) {
                previous = parent;
            }
            minimum = previous.getLineNo();
        }
        return minimum;
    }

    private static boolean isFirst(DetailAST node) {
        DetailAST previous = node.getPreviousSibling();
        return null == previous;
    }

    private static boolean isField(DetailAST node) {
        boolean yes = true;
        if (10 == node.getType()) {
            yes = 6 == node.getParent().getType();
        }
        return yes;
    }

    private static int findCommentEnd(String[] lines, int start) {
        return JavadocLocationCheck.findTrimmedTextUp(lines, start, "*/");
    }

    private static int findTrimmedTextUp(String[] lines, int start, String text) {
        int found = -1;
        for (int pos = start - 1; pos >= 0; --pos) {
            if (!lines[pos].trim().equals(text)) continue;
            found = pos + 1;
            break;
        }
        return found;
    }
}

