/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class JavadocEmptyLineCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return new int[]{16, 14, 15, 157, 161, 154, 155, 10, 8, 9};
    }

    public void visitToken(DetailAST ast) {
        int current;
        String[] lines = this.getLines();
        int start = JavadocEmptyLineCheck.findCommentStart(lines, current = ast.getLineNo()) + 1;
        if (JavadocEmptyLineCheck.isNodeHavingJavadoc(ast, start)) {
            int end;
            if (JavadocEmptyLineCheck.isJavadocLineEmpty(lines[start])) {
                this.log(start + 1, "Empty Javadoc line at the beginning", new Object[0]);
            }
            if (JavadocEmptyLineCheck.isJavadocLineEmpty(lines[end = JavadocEmptyLineCheck.findCommentEnd(lines, current) - 1])) {
                this.log(end + 1, "Empty Javadoc line at the end", new Object[0]);
            }
        }
    }

    private static boolean isJavadocLineEmpty(String line) {
        return "*".equals(line.trim());
    }

    private static boolean isNodeHavingJavadoc(DetailAST node, int start) {
        return start > JavadocEmptyLineCheck.getLineNoOfPreviousNode(node);
    }

    private static int getLineNoOfPreviousNode(DetailAST node) {
        int start = 0;
        DetailAST previous = node.getPreviousSibling();
        if (previous != null) {
            start = previous.getLineNo();
        }
        return start;
    }

    private static int findCommentStart(String[] lines, int start) {
        return JavadocEmptyLineCheck.findTrimmedTextUp(lines, start, "/**");
    }

    private static int findCommentEnd(String[] lines, int start) {
        return JavadocEmptyLineCheck.findTrimmedTextUp(lines, start, "*/");
    }

    private static int findTrimmedTextUp(String[] lines, int start, String text) {
        int found = -1;
        for (int pos = start - 1; pos >= 0; --pos) {
            if (!lines[pos].trim().equals(text)) continue;
            found = pos;
            break;
        }
        return found;
    }
}

