/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.qulice.checkstyle.LineRange;
import com.qulice.checkstyle.LineRanges;
import java.util.regex.Pattern;

public final class EmptyLinesCheck
extends AbstractCheck {
    private static final Pattern PATTERN = Pattern.compile("^\\s*$");
    private final LineRanges anons = new LineRanges();
    private final LineRanges methods = new LineRanges();

    public int[] getDefaultTokens() {
        return new int[]{9, 8, 6};
    }

    public void visitToken(DetailAST ast) {
        DetailAST opening;
        if (ast.getType() == 6 && ast.getParent() != null && ast.getParent().getType() == 136) {
            DetailAST left = ast.findFirstToken(72);
            DetailAST right = ast.findFirstToken(73);
            if (left != null && right != null) {
                this.anons.add(new LineRange(left.getLineNo(), right.getLineNo()));
            }
        } else if ((ast.getType() == 9 || ast.getType() == 8) && (opening = ast.findFirstToken(7)) != null) {
            DetailAST right = opening.findFirstToken(73);
            this.methods.add(new LineRange(opening.getLineNo(), right.getLineNo()));
        }
    }

    public void finishTree(DetailAST root) {
        String[] lines = this.getLines();
        for (int line = 0; line < lines.length; ++line) {
            if (!this.methods.inRange(line + 1) || !this.validInnerClassMethod(line + 1) || !PATTERN.matcher(lines[line]).find()) continue;
            this.log(line + 1, "Empty line inside method", new Object[0]);
        }
        this.methods.clear();
        this.anons.clear();
        super.finishTree(root);
    }

    private boolean validInnerClassMethod(int line) {
        return !this.anons.inRange(line) || this.methods.within(this.anons).inRange(line);
    }
}

