/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class ConstantUsageCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public void visitToken(DetailAST ast) {
        DetailAST namenode;
        if (ConstantUsageCheck.isField(ast) && ConstantUsageCheck.isFinal(ast) && !"serialVersionUID".equals(this.getText(namenode = ast.findFirstToken(58)))) {
            this.checkField(ast, namenode);
        }
    }

    private void checkField(DetailAST ast, DetailAST namenode) {
        String name = namenode.getText();
        int line = namenode.getLineNo();
        int counter = 0;
        block4: for (DetailAST variable = ast.getNextSibling(); null != variable; variable = variable.getNextSibling()) {
            switch (variable.getType()) {
                case 10: {
                    counter += this.parseVarDef(variable, name);
                    continue block4;
                }
                case 14: {
                    counter += this.parseDef(variable, name, 6);
                    continue block4;
                }
                default: {
                    counter += this.parseDef(variable, name, 7);
                }
            }
        }
        if (counter == 0 && ConstantUsageCheck.isPrivate(ast)) {
            this.log(line, String.format("Private constant \"%s\" is not used", name), new Object[0]);
        }
    }

    private int parseVarDef(DetailAST variable, String name) {
        int counter = 0;
        DetailAST assign = variable.findFirstToken(80);
        if (assign != null) {
            String text;
            DetailAST expression = assign.findFirstToken(28);
            if (expression == null) {
                expression = assign.findFirstToken(29);
            }
            if ((text = this.getText(expression)).contains(name)) {
                ++counter;
            }
        }
        return counter;
    }

    private String getText(DetailAST node) {
        String ret;
        if (0 == node.getChildCount()) {
            ret = node.getText();
        } else {
            StringBuilder result = new StringBuilder();
            for (DetailAST child = node.getFirstChild(); null != child; child = child.getNextSibling()) {
                String text = this.getText(child);
                result.append(text);
                if (!".".equals(node.getText()) || child.getNextSibling() == null) continue;
                result.append(node.getText());
            }
            ret = result.toString();
        }
        return ret;
    }

    private static boolean isField(DetailAST node) {
        DetailAST parent = node.getParent();
        return 6 == parent.getType();
    }

    private static boolean isFinal(DetailAST node) {
        DetailAST modifiers = node.findFirstToken(5);
        return modifiers.branchContains(39);
    }

    private static boolean isPrivate(DetailAST node) {
        DetailAST modifiers = node.findFirstToken(5);
        return modifiers.branchContains(61);
    }

    private int parseDef(DetailAST definition, String name, int type) {
        DetailAST opening;
        int counter = 0;
        DetailAST modifiers = definition.findFirstToken(5);
        if (modifiers != null) {
            counter += this.parseAnnotation(modifiers, name);
        }
        if (null != (opening = definition.findFirstToken(type))) {
            DetailAST closing = opening.findFirstToken(73);
            int start = opening.getLineNo();
            int end = closing.getLineNo() - 1;
            String[] lines = this.getLines();
            for (int pos = start; pos < end; ++pos) {
                if (!lines[pos].contains(name)) continue;
                ++counter;
            }
        }
        return counter;
    }

    private int parseAnnotation(DetailAST modifiers, String name) {
        String txt;
        int counter = 0;
        DetailAST variable = modifiers.findFirstToken(159);
        if (variable != null && (txt = this.getText(variable)).contains(name)) {
            ++counter;
        }
        return counter;
    }
}

