/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class CascadeIndentationCheck
extends AbstractFileSetCheck {
    private static final int LINE_INDENT_DIFF = 4;

    public void processFiltered(File file, List<String> lines) {
        int previous = 0;
        for (int pos = 0; pos < lines.size(); ++pos) {
            String line = lines.get(pos);
            int current = CascadeIndentationCheck.indentation(line);
            if (CascadeIndentationCheck.inCommentBlock(line) || line.isEmpty()) continue;
            if (current > previous && current != previous + 4) {
                this.log(pos + 1, String.format(StringUtils.join((Object[])new String[]{"Indentation (%d) must be same or ", "less than previous line (%d), or ", "bigger by exactly 4"}), current, previous), new Object[0]);
            }
            previous = current;
        }
    }

    private static boolean inCommentBlock(String line) {
        String trimmed = line.trim();
        return trimmed.length() > 0 && (trimmed.charAt(0) == '*' || trimmed.startsWith("/*") || trimmed.startsWith("*/"));
    }

    private static int indentation(String line) {
        int result = 0;
        for (int pos = 0; pos < line.length() && Character.isWhitespace(line.charAt(pos)); ++pos) {
            ++result;
        }
        return result;
    }
}

