/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class BracketsStructureCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return new int[]{136, 27};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 27 || ast.getType() == 136) {
            this.checkParams(ast);
        } else {
            DetailAST brackets = ast.findFirstToken(76);
            if (brackets != null) {
                this.checkParams(brackets);
            }
        }
    }

    private void checkParams(DetailAST node) {
        DetailAST closing = node.findFirstToken(77);
        if (closing != null) {
            this.checkLines(node, node.getLineNo(), closing.getLineNo());
        }
    }

    private void checkLines(DetailAST node, int start, int end) {
        if (start != end) {
            DetailAST elist = node.findFirstToken(34);
            int pline = elist.getLineNo();
            if (pline == start) {
                this.log(pline, "Parameters should start on a new line", new Object[0]);
            }
            this.checkExpressionList(elist, end);
        }
    }

    private void checkExpressionList(DetailAST elist, int end) {
        DetailAST last;
        int lline;
        if (elist.getChildCount() > 0 && (lline = (last = elist.getLastChild()).getLineNo()) == end) {
            this.log(lline, "Closing bracket should be on a new line", new Object[0]);
        }
    }
}

