/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.spatial;

import com.querydsl.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;
import org.jetbrains.annotations.Nullable;

class H2GISWkbType
extends AbstractType<Geometry> {
    public static final H2GISWkbType DEFAULT = new H2GISWkbType();
    private final ByteOrder byteOrder = ByteOrder.NDR;

    H2GISWkbType() {
        super(2004);
    }

    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        byte[] bytes = rs.getBytes(startIndex);
        if (bytes != null) {
            byte[] wkb;
            if (bytes[0] != 0 && bytes[0] != 1) {
                wkb = new byte[bytes.length - 32];
                System.arraycopy(bytes, 32, wkb, 0, wkb.length);
            } else {
                wkb = bytes;
            }
            WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
            return decoder.decode(ByteBuffer.from((byte[])wkb));
        }
        return null;
    }

    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
        ByteBuffer buffer = encoder.encode(value, this.byteOrder);
        st.setBytes(startIndex, buffer.toByteArray());
    }

    public String getLiteral(Geometry geometry) {
        String str = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(geometry);
        if (geometry.getSRID() > -1) {
            return "ST_GeomFromText('" + str + "', " + geometry.getSRID() + ")";
        }
        return "ST_GeomFromText('" + str + "', -1)";
    }
}

