/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.querydsl.core.JoinType;
import com.querydsl.core.dml.InsertClause;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.impl.JPAProvider;
import com.querydsl.jpa.impl.JPAUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.jetbrains.annotations.Nullable;

public class JPAInsertClause
implements InsertClause<JPAInsertClause> {
    private final QueryMixin<?> queryMixin = new JPAQueryMixin();
    private final Map<Path<?>, Expression<?>> inserts = new LinkedHashMap();
    private final List<Path<?>> columns = new ArrayList();
    private final List<Object> values = new ArrayList<Object>();
    private final EntityManager entityManager;
    private final JPQLTemplates templates;
    private SubQueryExpression<?> subQuery;
    @Nullable
    private LockModeType lockMode;

    public JPAInsertClause(EntityManager em, EntityPath<?> entity) {
        this(em, entity, JPAProvider.getTemplates(em));
    }

    public JPAInsertClause(EntityManager em, EntityPath<?> entity, JPQLTemplates templates) {
        this.entityManager = em;
        this.templates = templates;
        this.queryMixin.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForInsert(this.queryMixin.getMetadata(), this.inserts.isEmpty() ? this.columns : this.inserts.keySet(), this.values, this.subQuery, this.inserts);
        Query query = this.entityManager.createQuery(serializer.toString());
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        JPAUtil.setConstants(query, serializer.getConstants(), this.queryMixin.getMetadata().getParams());
        return query.executeUpdate();
    }

    public JPAInsertClause setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForInsert(this.queryMixin.getMetadata(), this.inserts.isEmpty() ? this.columns : this.inserts.keySet(), this.values, this.subQuery, this.inserts);
        return serializer.toString();
    }

    public JPAInsertClause columns(Path<?> ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public JPAInsertClause select(SubQueryExpression<?> sq) {
        this.subQuery = sq;
        return this;
    }

    public JPAInsertClause values(Object ... v) {
        this.values.addAll(Arrays.asList(v));
        return this;
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public <T> JPAInsertClause set(Path<T> path, T value) {
        if (value != null) {
            this.inserts.put(path, Expressions.constant(value));
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAInsertClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.inserts.put(path, expression);
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAInsertClause setNull(Path<T> path) {
        this.inserts.put(path, (Expression<?>)Expressions.nullExpression(path));
        return this;
    }
}

