/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.codegen;

import com.querydsl.codegen.CodegenModule;
import com.querydsl.codegen.EmbeddableSerializer;
import com.querydsl.codegen.EntitySerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.Supertype;
import com.querydsl.codegen.SupertypeSerializer;
import com.querydsl.codegen.TypeFactory;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.JavaWriter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.core.QueryException;
import com.querydsl.core.annotations.Config;
import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.annotations.QueryInit;
import com.querydsl.core.annotations.QueryType;
import com.querydsl.core.util.Annotations;
import com.querydsl.core.util.ReflectionUtils;
import com.querydsl.jpa.codegen.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomainExporter {
    private static final Logger logger = Logger.getLogger(AbstractDomainExporter.class.getName());
    private final File targetFolder;
    private final Map<Class<?>, EntityType> allTypes = new HashMap();
    private final Map<Class<?>, EntityType> entityTypes = new HashMap();
    private final Map<Class<?>, EntityType> embeddableTypes = new HashMap();
    private final Map<Class<?>, EntityType> superTypes = new HashMap();
    private final Map<Class<?>, SerializerConfig> typeToConfig = new HashMap();
    private final Set<EntityType> serialized = new HashSet<EntityType>();
    protected final TypeFactory typeFactory = new TypeFactory(Arrays.asList(Entity.class, MappedSuperclass.class, Embeddable.class));
    private final QueryTypeFactory queryTypeFactory;
    private final TypeMappings typeMappings;
    private final Serializer embeddableSerializer;
    private final Serializer entitySerializer;
    private final Serializer supertypeSerializer;
    private final SerializerConfig serializerConfig;
    private final Charset charset;
    private final Set<File> generatedFiles = new HashSet<File>();
    private Function<EntityType, String> variableNameFunction;

    public AbstractDomainExporter(String namePrefix, String nameSuffix, File targetFolder, SerializerConfig serializerConfig, Charset charset) {
        this.targetFolder = targetFolder;
        this.serializerConfig = serializerConfig;
        this.charset = charset;
        CodegenModule module = new CodegenModule();
        module.bind("prefix", (Object)namePrefix);
        module.bind("suffix", (Object)nameSuffix);
        module.bind("keywords", Constants.keywords);
        module.loadExtensions();
        this.queryTypeFactory = (QueryTypeFactory)module.get(QueryTypeFactory.class);
        this.typeMappings = (TypeMappings)module.get(TypeMappings.class);
        this.embeddableSerializer = (Serializer)module.get(EmbeddableSerializer.class);
        this.entitySerializer = (Serializer)module.get(EntitySerializer.class);
        this.supertypeSerializer = (Serializer)module.get(SupertypeSerializer.class);
        this.variableNameFunction = (Function)module.get(Function.class, "variableNameFunction");
    }

    public void execute() throws IOException {
        try {
            this.collectTypes();
        }
        catch (Exception e) {
            throw new QueryException((Throwable)e);
        }
        HashSet<Supertype> additions = new HashSet<Supertype>();
        for (Map.Entry<Class<?>, EntityType> entry : this.allTypes.entrySet()) {
            EntityType entityType = entry.getValue();
            if (entityType.getSuperType() == null || this.allTypes.containsKey(entityType.getSuperType().getType().getJavaClass())) continue;
            additions.add(entityType.getSuperType());
        }
        for (Supertype type : additions) {
            type.setEntityType(this.createEntityType(type.getType(), this.superTypes));
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : this.superTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.entityTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.embeddableTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        this.serialize(this.superTypes, this.supertypeSerializer);
        this.serialize(this.embeddableTypes, this.embeddableSerializer);
        this.serialize(this.entityTypes, this.entitySerializer);
    }

    private void addSupertypeFields(EntityType model, Map<Class<?>, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getJavaClass());
                if (entityType == null) continue;
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    protected abstract void collectTypes() throws Exception;

    protected EntityType createEmbeddableType(Class<?> cl) {
        return this.createEntityType(cl, this.embeddableTypes);
    }

    protected EntityType createEmbeddableType(Type type) {
        return this.createEntityType(type, this.embeddableTypes);
    }

    protected EntityType createEntityType(Class<?> cl) {
        return this.createEntityType(cl, this.entityTypes);
    }

    private EntityType createEntityType(Class<?> cl, Map<Class<?>, EntityType> types) {
        if (this.allTypes.containsKey(cl)) {
            return this.allTypes.get(cl);
        }
        EntityType type = this.typeFactory.getEntityType(cl);
        this.registerConfig(type);
        this.typeMappings.register((Type)type, this.queryTypeFactory.create((Type)type));
        if (!cl.getSuperclass().equals(Object.class)) {
            type.addSupertype(new Supertype(this.typeFactory.get(cl.getSuperclass(), cl.getGenericSuperclass())));
        }
        types.put(cl, type);
        this.allTypes.put(cl, type);
        return type;
    }

    protected EntityType createEntityType(Type type) {
        return this.createEntityType(type, this.entityTypes);
    }

    protected EntityType createEntityType(Type type, Map<Class<?>, EntityType> types) {
        Class key = type.getJavaClass();
        if (this.allTypes.containsKey(key)) {
            return this.allTypes.get(key);
        }
        EntityType entityType = new EntityType(type, this.variableNameFunction);
        this.registerConfig(entityType);
        this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
        Class superClass = key.getSuperclass();
        if (entityType.getSuperType() == null && superClass != null && !superClass.equals(Object.class)) {
            entityType.addSupertype(new Supertype(this.typeFactory.get(superClass, key.getGenericSuperclass())));
        }
        types.put(key, entityType);
        this.allTypes.put(key, entityType);
        return entityType;
    }

    private void registerConfig(EntityType entityType) {
        Class key = entityType.getJavaClass();
        Config config = key.getAnnotation(Config.class);
        if (config == null && key.getPackage() != null) {
            config = key.getPackage().getAnnotation(Config.class);
        }
        if (config != null) {
            this.typeToConfig.put(key, SimpleSerializerConfig.getConfig((Config)config));
        }
    }

    @Nullable
    protected Type getTypeOverride(Type propertyType, AnnotatedElement annotated) {
        if (annotated.isAnnotationPresent(QueryType.class)) {
            QueryType queryType = annotated.getAnnotation(QueryType.class);
            if (queryType.value().equals((Object)PropertyType.NONE)) {
                return null;
            }
            return propertyType.as(TypeCategory.valueOf((String)queryType.value().name()));
        }
        return propertyType;
    }

    protected Property createProperty(EntityType entityType, String propertyName, Type propertyType, AnnotatedElement annotated) {
        List<Object> inits = Collections.emptyList();
        if (annotated.isAnnotationPresent(QueryInit.class)) {
            inits = Collections.unmodifiableList(Arrays.asList(annotated.getAnnotation(QueryInit.class).value()));
        }
        return new Property(entityType, propertyName, propertyType, inits);
    }

    protected EntityType createSuperType(Class<?> cl) {
        return this.createEntityType(cl, this.superTypes);
    }

    protected AnnotatedElement getAnnotatedElement(Class<?> cl, String propertyName) throws NoSuchMethodException {
        Field field = ReflectionUtils.getFieldOrNull(cl, (String)propertyName);
        Method method = ReflectionUtils.getGetterOrNull(cl, (String)propertyName);
        if (field != null) {
            if (method != null) {
                return new Annotations(new AnnotatedElement[]{field, method});
            }
            return field;
        }
        if (method != null) {
            return method;
        }
        throw new IllegalArgumentException("No property found for " + cl.getName() + "." + propertyName);
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    protected Type getType(Class<?> cl, Class<?> mappedType, String propertyName) throws NoSuchMethodException {
        Field field = ReflectionUtils.getFieldOrNull(cl, (String)propertyName);
        if (field != null) {
            if (mappedType.isAssignableFrom(field.getType())) {
                return this.typeFactory.get(field.getType(), field.getGenericType());
            }
            return this.typeFactory.get(mappedType);
        }
        Method method = ReflectionUtils.getGetterOrNull(cl, (String)propertyName);
        if (method != null) {
            if (mappedType.isAssignableFrom(method.getReturnType())) {
                return this.typeFactory.get(method.getReturnType(), method.getGenericReturnType());
            }
            return this.typeFactory.get(mappedType);
        }
        throw new IllegalArgumentException("No property found for " + cl.getName() + "." + propertyName);
    }

    private void serialize(Map<Class<?>, EntityType> types, Serializer serializer) throws IOException {
        for (EntityType entityType : types.values()) {
            if (!this.serialized.add(entityType)) continue;
            Type type = this.typeMappings.getPathType((Type)entityType, entityType, true);
            String packageName = type.getPackageName();
            String className = packageName.length() > 0 ? packageName + "." + type.getSimpleName() : type.getSimpleName();
            this.write(serializer, className.replace('.', '/') + ".java", entityType);
        }
    }

    private void write(Serializer serializer, String path, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        this.generatedFiles.add(targetFile);
        try (Writer w = this.writerFor(targetFile);){
            JavaWriter writer = new JavaWriter((Appendable)w);
            if (this.typeToConfig.containsKey(type.getJavaClass())) {
                serializer.serialize(type, this.typeToConfig.get(type.getJavaClass()), (CodeWriter)writer);
            } else {
                serializer.serialize(type, this.serializerConfig, (CodeWriter)writer);
            }
        }
    }

    private Writer writerFor(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.log(Level.WARNING, "Folder " + file.getParent() + " could not be created");
        }
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Type normalize(Type first, Type second) {
        if (first.getFullName().equals(second.getFullName())) {
            return first;
        }
        return second;
    }

    public void setUnknownAsEntity(boolean unknownAsEntity) {
        this.typeFactory.setUnknownAsEntity(unknownAsEntity);
    }
}

