/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.StringPath;
import org.junit.Assert;
import org.junit.Test;

public class CoalesceTest {
    private final StringPath firstname = new StringPath("firstname");
    private final StringPath lastname = new StringPath("lastname");

    @Test
    public void mutable() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname}).add((Comparable)((Object)"xxx"));
        Assert.assertEquals((Object)"coalesce(firstname, lastname, xxx)", (Object)c.toString());
        Assert.assertEquals((Object)"coalesce(firstname, lastname, xxx, yyy)", (Object)c.add((Comparable)((Object)"yyy")).toString());
    }

    @Test
    public void withList() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname}).add((Comparable)((Object)"xxx"));
        Assert.assertEquals((Object)"coalesce(firstname, lastname, xxx)", (Object)c.toString());
    }

    @Test
    public void withSingleArg() {
        Coalesce c = new Coalesce(new Expression[0]).add((Comparable)((Object)"xxx"));
        Assert.assertEquals((Object)"coalesce(xxx)", (Object)c.toString());
    }

    @Test
    public void asComparable() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname});
        c.getValue().asc();
    }

    @Test
    public void asString() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname});
        c.asString().lower();
    }

    @Test
    public void withoutWarnings() {
        Coalesce c = new Coalesce(String.class, new Expression[0]).add((Expression)this.firstname).add((Expression)this.lastname);
        Assert.assertEquals((Object)"coalesce(firstname, lastname)", (Object)c.toString());
    }

    @Test
    public void dsl() {
        Assert.assertEquals((Object)"coalesce(firstname, lastname)", (Object)this.firstname.coalesce((Expression)this.lastname).toString());
    }

    @Test
    public void dsl2() {
        Assert.assertEquals((Object)"coalesce(firstname, lastname, xxx)", (Object)new Coalesce(new Expression[0]).add((Expression)this.firstname).add((Expression)this.lastname).add((Comparable)((Object)"xxx")).toString());
    }

    @Test
    public void dsl3() {
        Assert.assertEquals((Object)"coalesce(firstname, xxx)", (Object)this.firstname.coalesce("xxx").toString());
    }

    @Test
    public void asc() {
        Assert.assertEquals((Object)"coalesce(firstname, xxx) ASC", (Object)this.firstname.coalesce("xxx").asc().toString());
    }

    @Test
    public void desc() {
        Assert.assertEquals((Object)"coalesce(firstname, xxx) DESC", (Object)this.firstname.coalesce("xxx").desc().toString());
    }
}

