/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.support.ReplaceVisitor;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringOperation;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class ReplaceVisitorTest {
    private static final ReplaceVisitor<Void> visitor = new ReplaceVisitor<Void>(){

        public Expression<?> visit(Path<?> expr, @Nullable Void context) {
            if (expr.getMetadata().isRoot()) {
                return ExpressionUtils.path((Class)expr.getType(), (String)(expr.getMetadata().getName() + "_"));
            }
            return super.visit(expr, (Object)context);
        }
    };

    @Test
    public void operation() {
        StringPath str = Expressions.stringPath((Path)ExpressionUtils.path(Object.class, (String)"customer"), (String)"name");
        StringPath str2 = Expressions.stringPath((String)"str");
        StringOperation concat = Expressions.stringOperation((Operator)Ops.CONCAT, (Expression[])new Expression[]{str, str2});
        Assert.assertEquals((Object)"customer.name + str", (Object)concat.toString());
        Assert.assertEquals((Object)"customer_.name + str_", (Object)((Expression)concat.accept(visitor, null)).toString());
    }

    @Test
    public void templateExpression() {
        StringPath str = Expressions.stringPath((Path)ExpressionUtils.path(Object.class, (String)"customer"), (String)"name");
        StringPath str2 = Expressions.stringPath((String)"str");
        StringTemplate concat = Expressions.stringTemplate((String)"{0} + {1}", (Object[])new Object[]{str, str2});
        Assert.assertEquals((Object)"customer.name + str", (Object)concat.toString());
        Assert.assertEquals((Object)"customer_.name + str_", (Object)((Expression)concat.accept(visitor, null)).toString());
    }
}

