/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.NumberConstant;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.NumberExpression;
import java.util.Calendar;
import java.util.Date;

public final class DateConstant<D extends Date>
extends DateExpression<D>
implements Constant<D> {
    private static final long serialVersionUID = -5745611667058255826L;
    private final D date;
    private final Calendar calendar;

    public static <D extends Date> DateExpression<D> create(D date) {
        return new DateConstant<D>(date);
    }

    public DateConstant(D date) {
        super((Expression)ConstantImpl.create(date));
        this.date = (Date)((Date)date).clone();
        this.calendar = Calendar.getInstance();
        this.calendar.setTime((Date)date);
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)v.visit((Constant)this, context);
    }

    public NumberExpression<Integer> dayOfMonth() {
        return NumberConstant.create(this.calendar.get(5));
    }

    public NumberExpression<Integer> month() {
        return NumberConstant.create(this.calendar.get(2) + 1);
    }

    public NumberExpression<Integer> year() {
        return NumberConstant.create(this.calendar.get(1));
    }

    public NumberExpression<Integer> yearMonth() {
        return NumberConstant.create(this.calendar.get(1) * 100 + this.calendar.get(2) + 1);
    }

    public NumberExpression<Integer> dayOfWeek() {
        return NumberConstant.create(this.calendar.get(7));
    }

    public NumberExpression<Integer> dayOfYear() {
        return NumberConstant.create(this.calendar.get(6));
    }

    public NumberExpression<Integer> week() {
        return NumberConstant.create(this.calendar.get(3));
    }

    public D getConstant() {
        return this.date;
    }
}

