/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.collections.CollQueryMixin;
import com.querydsl.collections.QueryEngine;
import com.querydsl.core.FetchableQuery;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryResults;
import com.querydsl.core.support.FetchableQueryBase;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.MapExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCollQuery<T, Q extends AbstractCollQuery<T, Q>>
extends FetchableQueryBase<T, Q>
implements FetchableQuery<T, Q> {
    private final Map<Expression<?>, Iterable<?>> iterables = new HashMap();
    private final QueryEngine queryEngine;

    public AbstractCollQuery(QueryMetadata metadata, QueryEngine queryEngine) {
        super(new CollQueryMixin(metadata));
        AbstractCollQuery self = this;
        this.queryMixin.setSelf((Object)self);
        this.queryEngine = queryEngine;
    }

    public long fetchCount() {
        return this.queryEngine.count(this.queryMixin.getMetadata(), this.iterables);
    }

    protected QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    private <D> Expression<D> createAlias(Path<? extends Collection<D>> target, Path<D> alias) {
        return ExpressionUtils.operation((Class)alias.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{target, alias});
    }

    private <D> Expression<D> createAlias(MapExpression<?, D> target, Path<D> alias) {
        return ExpressionUtils.operation((Class)alias.getType(), (Operator)Ops.ALIAS, (Expression[])new Expression[]{target, alias});
    }

    public <A> Q from(Path<A> entity, Iterable<? extends A> col) {
        this.iterables.put((Expression<?>)entity, col);
        this.getMetadata().addJoin(JoinType.DEFAULT, entity);
        return (Q)((Object)((AbstractCollQuery)((Object)this.queryMixin.getSelf())));
    }

    public <A> Q bind(Path<A> entity, Iterable<? extends A> col) {
        this.iterables.put((Expression<?>)entity, col);
        return (Q)((Object)((AbstractCollQuery)((Object)this.queryMixin.getSelf())));
    }

    public Q groupBy(Expression<?> e) {
        throw new UnsupportedOperationException();
    }

    public Q groupBy(Expression<?> ... o) {
        throw new UnsupportedOperationException();
    }

    public Q having(Predicate e) {
        throw new UnsupportedOperationException();
    }

    public Q having(Predicate ... e) {
        throw new UnsupportedOperationException();
    }

    protected QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public <P> Q innerJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)((AbstractCollQuery)((Object)this.queryMixin.getSelf())));
    }

    public <P> Q innerJoin(MapExpression<?, P> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return (Q)((Object)((AbstractCollQuery)((Object)this.queryMixin.getSelf())));
    }

    public <P> Q leftJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return (Q)((Object)((AbstractCollQuery)((Object)this.queryMixin.getSelf())));
    }

    public <P> Q leftJoin(MapExpression<?, P> target, Path<P> alias) {
        this.getMetadata().addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return (Q)((Object)((AbstractCollQuery)((Object)this.queryMixin.getSelf())));
    }

    public CloseableIterator<T> iterate() {
        Expression projection = this.queryMixin.getMetadata().getProjection();
        return new IteratorAdapter(this.queryEngine.list(this.getMetadata(), this.iterables, projection).iterator());
    }

    public List<T> fetch() {
        Expression projection = this.queryMixin.getMetadata().getProjection();
        return this.queryEngine.list(this.getMetadata(), this.iterables, projection);
    }

    public QueryResults<T> fetchResults() {
        Expression projection = this.queryMixin.getMetadata().getProjection();
        long count = this.queryEngine.count(this.getMetadata(), this.iterables);
        if (count > 0L) {
            List list = this.queryEngine.list(this.getMetadata(), this.iterables, projection);
            return new QueryResults(list, this.getMetadata().getModifiers(), count);
        }
        return QueryResults.emptyResults();
    }

    public T fetchOne() {
        this.queryMixin.setUnique(true);
        if (this.queryMixin.getMetadata().getModifiers().getLimit() == null) {
            this.limit(2L);
        }
        return (T)this.uniqueResult(this.iterate());
    }
}

