/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.ProjectionSerializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.Constructor;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.TypeExtends;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.NumberExpression;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;

public final class DefaultProjectionSerializer
implements ProjectionSerializer {
    private final Class<? extends Annotation> generatedAnnotationClass;
    private final TypeMappings typeMappings;

    public DefaultProjectionSerializer(TypeMappings typeMappings) {
        this(typeMappings, GeneratedAnnotationResolver.resolveDefault());
    }

    @Inject
    public DefaultProjectionSerializer(TypeMappings typeMappings, @Named(value="generatedAnnotationClass") Class<? extends Annotation> generatedAnnotationClass) {
        this.typeMappings = typeMappings;
        this.generatedAnnotationClass = generatedAnnotationClass;
    }

    protected void intro(EntityType model, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        Type queryType = this.typeMappings.getPathType((Type)model, model, false);
        if (!queryType.getPackageName().isEmpty()) {
            writer.packageDecl(queryType.getPackageName());
        }
        writer.imports(new Package[]{NumberExpression.class.getPackage()});
        writer.imports(new Class[]{ConstructorExpression.class, this.generatedAnnotationClass});
        HashSet<Integer> sizes = new HashSet<Integer>();
        for (Constructor c : model.getConstructors()) {
            sizes.add(c.getParameters().size());
        }
        if (sizes.size() != model.getConstructors().size()) {
            writer.imports(new Class[]{Expression.class});
        }
        writer.javadoc(new String[]{queryType + " is a Querydsl Projection type for " + simpleName});
        writer.line(new String[]{"@", this.generatedAnnotationClass.getSimpleName(), "(\"", this.getClass().getName(), "\")"});
        ClassType superType = new ClassType(TypeCategory.SIMPLE, ConstructorExpression.class, new Type[]{model});
        writer.beginClass(queryType, (Type)superType, new Type[0]);
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", model.hashCode() + "L");
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(final EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        this.intro(model, writer);
        String localName = writer.getRawName((Type)model);
        HashSet<Integer> sizes = new HashSet<Integer>();
        for (Constructor c : model.getConstructors()) {
            final boolean asExpr = sizes.add(c.getParameters().size());
            writer.beginConstructor(c.getParameters(), (Function)new Function<Parameter, Parameter>(){

                @Override
                public Parameter apply(Parameter p) {
                    Object type = !asExpr ? DefaultProjectionSerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) : (p.getType().isFinal() ? new ClassType(Expression.class, new Type[]{p.getType()}) : new ClassType(Expression.class, new Type[]{new TypeExtends(p.getType())}));
                    return new Parameter(p.getName(), type);
                }
            });
            writer.beginLine(new String[]{"super(" + writer.getClassConstant(localName)});
            writer.append((CharSequence)", new Class<?>[]{");
            boolean first = true;
            for (Parameter p : c.getParameters()) {
                if (!first) {
                    writer.append((CharSequence)", ");
                }
                if (Types.PRIMITIVES.containsKey(p.getType())) {
                    Type primitive = (Type)Types.PRIMITIVES.get(p.getType());
                    writer.append((CharSequence)writer.getClassConstant(primitive.getFullName()));
                } else {
                    writer.append((CharSequence)writer.getClassConstant(writer.getRawName(p.getType())));
                }
                first = false;
            }
            writer.append((CharSequence)"}");
            for (Parameter p : c.getParameters()) {
                writer.append((CharSequence)", ").append(p.getName());
            }
            writer.append((CharSequence)");\n");
            writer.end();
        }
        this.outro(model, writer);
    }
}

