/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.tiles;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import com.qozix.tileview.graphics.BitmapProvider;
import com.qozix.tileview.tiles.Tile;
import com.qozix.tileview.tiles.TileRenderHandler;
import java.lang.ref.WeakReference;

class TileRenderRunnable
implements Runnable {
    private WeakReference mTileWeakReference;
    private WeakReference mHandlerWeakReference;
    private WeakReference mContextWeakReference;
    private WeakReference mBitmapProviderWeakReference;
    private boolean mCancelled = false;
    private boolean mComplete = false;
    private volatile Thread mThread;
    private Throwable mThrowable;

    TileRenderRunnable() {
    }

    public boolean cancel(boolean bl) {
        if (bl && this.mThread != null) {
            this.mThread.interrupt();
        }
        boolean bl2 = this.mCancelled;
        this.mCancelled = true;
        return !bl2;
    }

    public boolean isCancelled() {
        return this.mCancelled;
    }

    public boolean isDone() {
        return this.mComplete;
    }

    public void setHandler(Handler handler) {
        this.mHandlerWeakReference = new WeakReference<Handler>(handler);
    }

    public Handler getHandler() {
        if (this.mHandlerWeakReference == null) {
            return null;
        }
        return (Handler)this.mHandlerWeakReference.get();
    }

    public void setContext(Context context) {
        this.mContextWeakReference = new WeakReference<Context>(context);
    }

    public void setBitmapProvider(BitmapProvider bitmapProvider) {
        this.mBitmapProviderWeakReference = new WeakReference<BitmapProvider>(bitmapProvider);
    }

    public Context getContext() {
        if (this.mContextWeakReference == null) {
            return null;
        }
        return (Context)this.mContextWeakReference.get();
    }

    public BitmapProvider getBitmapProvider() {
        if (this.mBitmapProviderWeakReference == null) {
            return null;
        }
        return (BitmapProvider)this.mBitmapProviderWeakReference.get();
    }

    public void setTile(Tile tile) {
        this.mTileWeakReference = new WeakReference<Tile>(tile);
    }

    public Tile getTile() {
        if (this.mTileWeakReference != null) {
            return (Tile)this.mTileWeakReference.get();
        }
        return null;
    }

    public Throwable getThrowable() {
        return this.mThrowable;
    }

    public TileRenderHandler.Status renderTile() {
        if (this.mCancelled) {
            return TileRenderHandler.Status.INCOMPLETE;
        }
        Process.setThreadPriority((int)10);
        if (this.mThread.isInterrupted()) {
            return TileRenderHandler.Status.INCOMPLETE;
        }
        Tile tile = this.getTile();
        if (tile == null) {
            return TileRenderHandler.Status.INCOMPLETE;
        }
        Context context = this.getContext();
        if (context == null) {
            return TileRenderHandler.Status.INCOMPLETE;
        }
        BitmapProvider bitmapProvider = this.getBitmapProvider();
        if (bitmapProvider == null) {
            return TileRenderHandler.Status.INCOMPLETE;
        }
        try {
            tile.generateBitmap(context, bitmapProvider);
        }
        catch (Throwable throwable) {
            this.mThrowable = throwable;
            return TileRenderHandler.Status.ERROR;
        }
        if (this.mCancelled || tile.getBitmap() == null || this.mThread.isInterrupted()) {
            tile.destroy(true);
            return TileRenderHandler.Status.INCOMPLETE;
        }
        return TileRenderHandler.Status.COMPLETE;
    }

    @Override
    public void run() {
        Handler handler;
        this.mThread = Thread.currentThread();
        TileRenderHandler.Status status = this.renderTile();
        if (status == TileRenderHandler.Status.INCOMPLETE) {
            return;
        }
        if (status == TileRenderHandler.Status.COMPLETE) {
            this.mComplete = true;
        }
        if ((handler = this.getHandler()) != null) {
            Message message = handler.obtainMessage(status.getMessageCode(), (Object)this);
            message.sendToTarget();
        }
    }
}

