/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.tiles;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.qozix.tileview.tiles.Tile;
import com.qozix.tileview.tiles.TileCanvasViewGroup;
import com.qozix.tileview.tiles.TileRenderRunnable;
import java.lang.ref.WeakReference;

class TileRenderHandler
extends Handler {
    public static final int RENDER_ERROR = -1;
    public static final int RENDER_INCOMPLETE = 0;
    public static final int RENDER_COMPLETE = 1;
    private WeakReference mTileCanvasViewGroupWeakReference;

    public TileRenderHandler() {
        this(Looper.getMainLooper());
    }

    public TileRenderHandler(Looper looper) {
        super(looper);
    }

    public void setTileCanvasViewGroup(TileCanvasViewGroup tileCanvasViewGroup) {
        this.mTileCanvasViewGroupWeakReference = new WeakReference<TileCanvasViewGroup>(tileCanvasViewGroup);
    }

    public TileCanvasViewGroup getTileCanvasViewGroup() {
        if (this.mTileCanvasViewGroupWeakReference == null) {
            return null;
        }
        return (TileCanvasViewGroup)this.mTileCanvasViewGroupWeakReference.get();
    }

    public void handleMessage(Message message) {
        TileRenderRunnable tileRenderRunnable = (TileRenderRunnable)message.obj;
        TileCanvasViewGroup tileCanvasViewGroup = this.getTileCanvasViewGroup();
        if (tileCanvasViewGroup == null) {
            return;
        }
        Tile tile = tileRenderRunnable.getTile();
        if (tile == null) {
            return;
        }
        switch (message.what) {
            case -1: {
                tileCanvasViewGroup.handleTileRenderException(tileRenderRunnable.getThrowable());
                break;
            }
            case 1: {
                tileCanvasViewGroup.addTileToCurrentTileCanvasView(tile);
            }
        }
    }

    public static enum Status {
        ERROR(-1),
        INCOMPLETE(0),
        COMPLETE(1);

        private int mMessageCode;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Status() {
            void var3_2;
            this.mMessageCode = var3_2;
        }

        int getMessageCode() {
            return this.mMessageCode;
        }
    }
}

