/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.tiles;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import com.qozix.tileview.tiles.Tile;
import java.util.HashSet;
import java.util.Set;

public class TileCanvasView
extends View {
    private float mScale = 1.0f;
    private Set mTiles = new HashSet();
    private TileCanvasDrawListener mTileCanvasDrawListener;
    private boolean mHasHadPendingUpdatesSinceLastCompleteDraw;

    public TileCanvasView(Context context) {
        super(context);
    }

    public Set getTiles() {
        return this.mTiles;
    }

    public void setScale(float f) {
        this.mScale = f;
        this.invalidate();
    }

    public float getScale() {
        return this.mScale;
    }

    public void setTileCanvasDrawListener(TileCanvasDrawListener tileCanvasDrawListener) {
        this.mTileCanvasDrawListener = tileCanvasDrawListener;
    }

    public void addTile(Tile tile) {
        if (!this.mTiles.contains(tile)) {
            this.mTiles.add(tile);
            tile.setParentTileCanvasView(this);
            this.invalidate();
        }
    }

    public void removeTile(Tile tile) {
        if (this.mTiles.contains(tile)) {
            this.mTiles.remove(tile);
            tile.setParentTileCanvasView(null);
            this.invalidate();
        }
    }

    public void clearTiles(boolean bl) {
        for (Tile tile : this.mTiles) {
            tile.destroy(bl, false);
        }
        this.mTiles.clear();
        this.invalidate();
    }

    private boolean drawTiles(Canvas canvas) {
        boolean bl = false;
        for (Tile tile : this.mTiles) {
            bl = tile.draw(canvas) || bl;
        }
        return bl;
    }

    private void handleDrawState(boolean bl) {
        if (bl) {
            this.invalidate();
            this.mHasHadPendingUpdatesSinceLastCompleteDraw = true;
            if (this.mTileCanvasDrawListener != null) {
                this.mTileCanvasDrawListener.onDrawPending(this);
            }
        } else if (this.mHasHadPendingUpdatesSinceLastCompleteDraw) {
            this.mHasHadPendingUpdatesSinceLastCompleteDraw = false;
            if (this.mTileCanvasDrawListener != null) {
                this.mTileCanvasDrawListener.onDrawComplete(this);
            }
        }
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        canvas.scale(this.mScale, this.mScale);
        boolean bl = this.drawTiles(canvas);
        canvas.restore();
        this.handleDrawState(bl);
    }

    public static interface TileCanvasDrawListener {
        public void onDrawComplete(TileCanvasView var1);

        public void onDrawPending(TileCanvasView var1);
    }
}

