/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.tiles;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.AnimationUtils;
import com.qozix.tileview.detail.DetailLevel;
import com.qozix.tileview.graphics.BitmapProvider;
import com.qozix.tileview.tiles.TileCanvasView;

public class Tile {
    private static final int DEFAULT_TRANSITION_DURATION = 200;
    private int mWidth;
    private int mHeight;
    private int mLeft;
    private int mTop;
    private int mRow;
    private int mColumn;
    private Object mData;
    private Bitmap mBitmap;
    public double renderTimestamp;
    private boolean mTransitionsEnabled;
    private int mTransitionDuration = 200;
    private Paint mPaint;
    private TileCanvasView mParentTileCanvasView;
    private DetailLevel mDetailLevel;

    public Tile(int n, int n2, int n3, int n4, Object object, DetailLevel detailLevel) {
        this.mRow = n2;
        this.mColumn = n;
        this.mWidth = n3;
        this.mHeight = n4;
        this.mLeft = n * n3;
        this.mTop = n2 * n4;
        this.mData = object;
        this.mDetailLevel = detailLevel;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getRow() {
        return this.mRow;
    }

    public int getColumn() {
        return this.mColumn;
    }

    public Object getData() {
        return this.mData;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public boolean hasBitmap() {
        return this.mBitmap != null;
    }

    public void setTransitionDuration(int n) {
        this.mTransitionDuration = n;
    }

    public void stampTime() {
        this.renderTimestamp = AnimationUtils.currentAnimationTimeMillis();
    }

    public void setTransitionsEnabled(boolean bl) {
        this.mTransitionsEnabled = bl;
    }

    public DetailLevel getDetailLevel() {
        return this.mDetailLevel;
    }

    public float getRendered() {
        if (!this.mTransitionsEnabled) {
            return 1.0f;
        }
        double d = AnimationUtils.currentAnimationTimeMillis();
        double d2 = d - this.renderTimestamp;
        float f = (float)Math.min(1.0, d2 / (double)this.mTransitionDuration);
        if (f == 1.0f) {
            this.mTransitionsEnabled = false;
        }
        return f;
    }

    public boolean getIsDirty() {
        return this.mTransitionsEnabled && this.getRendered() < 1.0f;
    }

    public Paint getPaint() {
        if (!this.mTransitionsEnabled) {
            return null;
        }
        if (this.mPaint == null) {
            this.mPaint = new Paint();
        }
        float f = this.getRendered();
        int n = (int)(f * 255.0f);
        this.mPaint.setAlpha(n);
        return this.mPaint;
    }

    void generateBitmap(Context context, BitmapProvider bitmapProvider) {
        if (this.mBitmap != null) {
            return;
        }
        this.mBitmap = bitmapProvider.getBitmap(this, context);
    }

    void setParentTileCanvasView(TileCanvasView tileCanvasView) {
        this.mParentTileCanvasView = tileCanvasView;
    }

    void destroy(boolean bl) {
        this.destroy(bl, true);
    }

    void destroy(boolean bl, boolean bl2) {
        if (bl && this.mBitmap != null && !this.mBitmap.isRecycled()) {
            this.mBitmap.recycle();
        }
        this.mBitmap = null;
        if (bl2 && this.mParentTileCanvasView != null) {
            this.mParentTileCanvasView.removeTile(this);
        }
    }

    boolean draw(Canvas canvas) {
        if (this.mBitmap != null) {
            canvas.drawBitmap(this.mBitmap, (float)this.mLeft, (float)this.mTop, this.getPaint());
        }
        return this.getIsDirty();
    }

    public int hashCode() {
        int n = 17;
        n = n * 31 + this.getColumn();
        n = n * 31 + this.getRow();
        n = n * 31 + (int)(1000.0f * this.getDetailLevel().getScale());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Tile) {
            Tile tile = (Tile)object;
            return tile.getRow() == this.getRow() && tile.getColumn() == this.getColumn() && tile.getDetailLevel().getScale() == this.getDetailLevel().getScale();
        }
        return false;
    }
}

