/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.paths;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.View;
import java.util.HashSet;

public class CompositePathView
extends View {
    private static final int DEFAULT_STROKE_COLOR = -16777216;
    private static final int DEFAULT_STROKE_WIDTH = 10;
    private float mScale = 1.0f;
    private boolean mShouldDraw = true;
    private Path mRecyclerPath = new Path();
    private Matrix mMatrix = new Matrix();
    private HashSet mDrawablePaths = new HashSet();
    private Paint mDefaultPaint = new Paint();

    public CompositePathView(Context context) {
        super(context);
        this.mDefaultPaint.setStyle(Paint.Style.STROKE);
        this.mDefaultPaint.setColor(-16777216);
        this.mDefaultPaint.setStrokeWidth(10.0f);
        this.mDefaultPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
    }

    public float getScale() {
        return this.mScale;
    }

    public void setScale(float f) {
        this.mScale = f;
        this.mMatrix.setScale(this.mScale, this.mScale);
        this.invalidate();
    }

    public Paint getDefaultPaint() {
        return this.mDefaultPaint;
    }

    public DrawablePath addPath(Path path, Paint paint) {
        if (paint == null) {
            paint = this.mDefaultPaint;
        }
        DrawablePath drawablePath = new DrawablePath();
        drawablePath.path = path;
        drawablePath.paint = paint;
        return this.addPath(drawablePath);
    }

    public DrawablePath addPath(DrawablePath drawablePath) {
        this.mDrawablePaths.add(drawablePath);
        this.invalidate();
        return drawablePath;
    }

    public void removePath(DrawablePath drawablePath) {
        this.mDrawablePaths.remove(drawablePath);
        this.invalidate();
    }

    public void clear() {
        this.mDrawablePaths.clear();
        this.invalidate();
    }

    public void setShouldDraw(boolean bl) {
        this.mShouldDraw = bl;
        this.invalidate();
    }

    public void onDraw(Canvas canvas) {
        if (this.mShouldDraw) {
            for (DrawablePath drawablePath : this.mDrawablePaths) {
                this.mRecyclerPath.set(drawablePath.path);
                this.mRecyclerPath.transform(this.mMatrix);
                canvas.drawPath(this.mRecyclerPath, drawablePath.paint);
            }
        }
        super.onDraw(canvas);
    }

    public static class DrawablePath {
        public Path path;
        public Paint paint;
    }
}

