/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.hotspots;

import com.qozix.tileview.geom.FloatMathHelper;
import com.qozix.tileview.hotspots.HotSpot;
import java.util.Iterator;
import java.util.LinkedList;

public class HotSpotManager {
    private float mScale = 1.0f;
    private HotSpot.HotSpotTapListener mHotSpotTapListener;
    private LinkedList mHotSpots = new LinkedList();

    public float getScale() {
        return this.mScale;
    }

    public void setScale(float f) {
        this.mScale = f;
    }

    public void addHotSpot(HotSpot hotSpot) {
        this.mHotSpots.add(hotSpot);
    }

    public void removeHotSpot(HotSpot hotSpot) {
        this.mHotSpots.remove((Object)hotSpot);
    }

    public void setHotSpotTapListener(HotSpot.HotSpotTapListener hotSpotTapListener) {
        this.mHotSpotTapListener = hotSpotTapListener;
    }

    public void clear() {
        this.mHotSpots.clear();
    }

    private HotSpot getMatch(int n, int n2) {
        int n3 = FloatMathHelper.unscale(n, this.mScale);
        int n4 = FloatMathHelper.unscale(n2, this.mScale);
        Iterator iterator = this.mHotSpots.descendingIterator();
        while (iterator.hasNext()) {
            HotSpot hotSpot = (HotSpot)((Object)iterator.next());
            if (!hotSpot.contains(n3, n4)) continue;
            return hotSpot;
        }
        return null;
    }

    public void processHit(int n, int n2) {
        HotSpot hotSpot = this.getMatch(n, n2);
        if (hotSpot != null) {
            HotSpot.HotSpotTapListener hotSpotTapListener = hotSpot.getHotSpotTapListener();
            if (hotSpotTapListener != null) {
                hotSpotTapListener.onHotSpotTap(hotSpot, n, n2);
            }
            if (this.mHotSpotTapListener != null) {
                this.mHotSpotTapListener.onHotSpotTap(hotSpot, n, n2);
            }
        }
    }
}

