/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.geom;

import android.graphics.Path;
import com.qozix.tileview.geom.FloatMathHelper;
import java.util.List;

public class CoordinateTranslater {
    private double mLeft;
    private double mTop;
    private double mRight;
    private double mBottom;
    private double mDiffX;
    private double mDiffY;
    private int mWidth;
    private int mHeight;
    private boolean mHasDefinedBounds;

    public void setSize(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.mHasDefinedBounds = true;
        this.mLeft = d;
        this.mTop = d2;
        this.mRight = d3;
        this.mBottom = d4;
        this.mDiffX = this.mRight - this.mLeft;
        this.mDiffY = this.mBottom - this.mTop;
    }

    public void unsetBounds() {
        this.mHasDefinedBounds = false;
        this.mLeft = 0.0;
        this.mTop = 0.0;
        this.mRight = this.mWidth;
        this.mBottom = this.mHeight;
        this.mDiffX = this.mWidth;
        this.mDiffY = this.mHeight;
    }

    public int translateX(double d) {
        if (!this.mHasDefinedBounds) {
            return (int)d;
        }
        double d2 = (d - this.mLeft) / this.mDiffX;
        return FloatMathHelper.scale(this.mWidth, (float)d2);
    }

    public int translateAndScaleX(double d, float f) {
        return FloatMathHelper.scale(this.translateX(d), f);
    }

    public int translateY(double d) {
        if (!this.mHasDefinedBounds) {
            return (int)d;
        }
        double d2 = (d - this.mTop) / this.mDiffY;
        return FloatMathHelper.scale(this.mHeight, (float)d2);
    }

    public int translateAndScaleY(double d, float f) {
        return FloatMathHelper.scale(this.translateY(d), f);
    }

    public double translateAbsoluteToRelativeX(float f) {
        return this.mLeft + (double)f * this.mDiffX / (double)this.mWidth;
    }

    public double translateAbsoluteToRelativeX(int n) {
        return this.translateAbsoluteToRelativeX((float)n);
    }

    public double translateAndScaleAbsoluteToRelativeX(float f, float f2) {
        return this.translateAbsoluteToRelativeX(f / f2);
    }

    public double translateAndScaleAbsoluteToRelativeX(int n, float f) {
        return this.translateAbsoluteToRelativeX((float)n / f);
    }

    public double translateAbsoluteToRelativeY(float f) {
        return this.mTop + (double)f * this.mDiffY / (double)this.mHeight;
    }

    public double translateAbsoluteToRelativeY(int n) {
        return this.translateAbsoluteToRelativeY((float)n);
    }

    public double translateAndScaleAbsoluteToRelativeY(float f, float f2) {
        return this.translateAbsoluteToRelativeY(f / f2);
    }

    public double translateAndScaleAbsoluteToRelativeY(int n, float f) {
        return this.translateAbsoluteToRelativeY((float)n / f);
    }

    public boolean contains(double d, double d2) {
        double d3 = this.mTop;
        double d4 = this.mBottom;
        double d5 = this.mLeft;
        double d6 = this.mRight;
        if (this.mTop > this.mBottom) {
            d3 = this.mBottom;
            d4 = this.mTop;
        }
        if (this.mLeft > this.mRight) {
            d5 = this.mRight;
            d6 = this.mLeft;
        }
        return d2 >= d3 && d2 <= d4 && d >= d5 && d <= d6;
    }

    public Path pathFromPositions(List list, boolean bl) {
        Path path = new Path();
        double[] dArray = (double[])list.get(0);
        path.moveTo((float)this.translateX(dArray[0]), (float)this.translateY(dArray[1]));
        for (int i = 1; i < list.size(); ++i) {
            double[] dArray2 = (double[])list.get(i);
            path.lineTo((float)this.translateX(dArray2[0]), (float)this.translateY(dArray2[1]));
        }
        if (bl) {
            path.close();
        }
        return path;
    }
}

