/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.qozix.tileview.detail.DetailLevel;
import com.qozix.tileview.detail.DetailLevelManager;
import com.qozix.tileview.geom.CoordinateTranslater;
import com.qozix.tileview.geom.FloatMathHelper;
import com.qozix.tileview.graphics.BitmapProvider;
import com.qozix.tileview.hotspots.HotSpot;
import com.qozix.tileview.hotspots.HotSpotManager;
import com.qozix.tileview.markers.CalloutLayout;
import com.qozix.tileview.markers.MarkerLayout;
import com.qozix.tileview.paths.CompositePathView;
import com.qozix.tileview.tiles.TileCanvasViewGroup;
import com.qozix.tileview.widgets.ScalingLayout;
import com.qozix.tileview.widgets.ZoomPanLayout;
import java.lang.ref.WeakReference;
import java.util.List;

public class TileView
extends ZoomPanLayout
implements DetailLevelManager.DetailLevelChangeListener,
TileCanvasViewGroup.TileRenderListener,
ZoomPanLayout.ZoomPanListener {
    protected static final int DEFAULT_TILE_SIZE = 256;
    private DetailLevelManager mDetailLevelManager = new DetailLevelManager();
    private CoordinateTranslater mCoordinateTranslater = new CoordinateTranslater();
    private HotSpotManager mHotSpotManager = new HotSpotManager();
    private TileCanvasViewGroup mTileCanvasViewGroup;
    private CompositePathView mCompositePathView;
    private ScalingLayout mScalingLayout;
    private MarkerLayout mMarkerLayout;
    private CalloutLayout mCalloutLayout;
    private RenderThrottleHandler mRenderThrottleHandler;
    private boolean mShouldRenderWhilePanning = false;
    private boolean mShouldUpdateDetailLevelWhileZooming = false;

    public TileView(Context context) {
        this(context, null);
    }

    public TileView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TileView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mTileCanvasViewGroup = new TileCanvasViewGroup(context);
        this.addView((View)this.mTileCanvasViewGroup);
        this.mCompositePathView = new CompositePathView(context);
        this.addView(this.mCompositePathView);
        this.mScalingLayout = new ScalingLayout(context);
        this.addView((View)this.mScalingLayout);
        this.mMarkerLayout = new MarkerLayout(context);
        this.addView((View)this.mMarkerLayout);
        this.mCalloutLayout = new CalloutLayout(context);
        this.addView((View)this.mCalloutLayout);
        this.mDetailLevelManager.setDetailLevelChangeListener(this);
        this.mTileCanvasViewGroup.setTileRenderListener(this);
        this.addZoomPanListener(this);
        this.mRenderThrottleHandler = new RenderThrottleHandler(this);
        this.requestRender();
    }

    public DetailLevelManager getDetailLevelManager() {
        return this.mDetailLevelManager;
    }

    public CoordinateTranslater getCoordinateTranslater() {
        return this.mCoordinateTranslater;
    }

    public HotSpotManager getHotSpotManager() {
        return this.mHotSpotManager;
    }

    public CompositePathView getCompositePathView() {
        return this.mCompositePathView;
    }

    public TileCanvasViewGroup getTileCanvasViewGroup() {
        return this.mTileCanvasViewGroup;
    }

    public MarkerLayout getMarkerLayout() {
        return this.mMarkerLayout;
    }

    public CalloutLayout getCalloutLayout() {
        return this.mCalloutLayout;
    }

    public ScalingLayout getScalingLayout() {
        return this.mScalingLayout;
    }

    public void addScalingViewGroup(ViewGroup viewGroup) {
        this.mScalingLayout.addView((View)viewGroup);
    }

    public void requestRender() {
        this.mTileCanvasViewGroup.requestRender();
    }

    public void requestThrottledRender() {
        this.mRenderThrottleHandler.submit();
    }

    protected void requestSafeRender() {
        if (this.isFlinging()) {
            this.requestThrottledRender();
        } else {
            this.requestRender();
        }
    }

    public void cancelRender() {
        this.mTileCanvasViewGroup.cancelRender();
    }

    public void suppressRender() {
        this.mTileCanvasViewGroup.suppressRender();
    }

    public void setBitmapProvider(BitmapProvider bitmapProvider) {
        this.mTileCanvasViewGroup.setBitmapProvider(bitmapProvider);
    }

    public void setTransitionsEnabled(boolean bl) {
        this.mTileCanvasViewGroup.setTransitionsEnabled(bl);
    }

    public void setShouldRecycleBitmaps(boolean bl) {
        this.mTileCanvasViewGroup.setShouldRecycleBitmaps(bl);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.mDetailLevelManager.setSize(n, n2);
        this.mCoordinateTranslater.setSize(n, n2);
    }

    public void addDetailLevel(float f, Object object) {
        this.addDetailLevel(f, object, 256, 256);
    }

    public void addDetailLevel(float f, Object object, int n, int n2) {
        this.mDetailLevelManager.addDetailLevel(f, object, n, n2);
    }

    public void setViewportPadding(int n) {
        this.mDetailLevelManager.setViewportPadding(n);
    }

    public void defineBounds(double d, double d2, double d3, double d4) {
        this.mCoordinateTranslater.setBounds(d, d2, d3, d4);
    }

    public void undefineBounds() {
        this.mCoordinateTranslater.unsetBounds();
    }

    public void scrollTo(double d, double d2) {
        this.scrollTo(this.mCoordinateTranslater.translateAndScaleX(d, this.getScale()), this.mCoordinateTranslater.translateAndScaleY(d2, this.getScale()));
    }

    public void scrollToAndCenter(double d, double d2) {
        this.scrollToAndCenter(this.mCoordinateTranslater.translateAndScaleX(d, this.getScale()), this.mCoordinateTranslater.translateAndScaleY(d2, this.getScale()));
    }

    public void slideTo(double d, double d2) {
        this.slideTo(this.mCoordinateTranslater.translateAndScaleX(d, this.getScale()), this.mCoordinateTranslater.translateAndScaleY(d2, this.getScale()));
    }

    public void slideToAndCenter(double d, double d2) {
        this.slideToAndCenter(this.mCoordinateTranslater.translateAndScaleX(d, this.getScale()), this.mCoordinateTranslater.translateAndScaleY(d2, this.getScale()));
    }

    public void slideToAndCenterWithScale(double d, double d2, float f) {
        this.slideToAndCenterWithScale(this.mCoordinateTranslater.translateAndScaleX(d, f), this.mCoordinateTranslater.translateAndScaleY(d2, f), f);
    }

    public void setMarkerAnchorPoints(Float f, Float f2) {
        this.mMarkerLayout.setAnchors(f.floatValue(), f2.floatValue());
    }

    public View addMarker(View view, double d, double d2, Float f, Float f2) {
        return this.mMarkerLayout.addMarker(view, this.mCoordinateTranslater.translateX(d), this.mCoordinateTranslater.translateY(d2), f, f2);
    }

    public void removeMarker(View view) {
        this.mMarkerLayout.removeMarker(view);
    }

    public void moveMarker(View view, double d, double d2) {
        this.mMarkerLayout.moveMarker(view, this.mCoordinateTranslater.translateX(d), this.mCoordinateTranslater.translateY(d2));
    }

    public void moveToMarker(View view, boolean bl) {
        if (this.mMarkerLayout.indexOfChild(view) == -1) {
            throw new IllegalStateException("The view passed is not an existing marker");
        }
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof MarkerLayout.LayoutParams) {
            MarkerLayout.LayoutParams layoutParams2 = (MarkerLayout.LayoutParams)layoutParams;
            int n = FloatMathHelper.scale(layoutParams2.x, this.getScale());
            int n2 = FloatMathHelper.scale(layoutParams2.y, this.getScale());
            if (bl) {
                this.slideToAndCenter(n, n2);
            } else {
                this.scrollToAndCenter(n, n2);
            }
        }
    }

    public void setMarkerTapListener(MarkerLayout.MarkerTapListener markerTapListener) {
        this.mMarkerLayout.setMarkerTapListener(markerTapListener);
    }

    public View addCallout(View view, double d, double d2, Float f, Float f2) {
        return this.mCalloutLayout.addMarker(view, this.mCoordinateTranslater.translateX(d), this.mCoordinateTranslater.translateY(d2), f, f2);
    }

    public void removeCallout(View view) {
        this.mCalloutLayout.removeMarker(view);
    }

    public HotSpot addHotSpot(HotSpot hotSpot) {
        this.mHotSpotManager.addHotSpot(hotSpot);
        return hotSpot;
    }

    public HotSpot addHotSpot(List list, HotSpot.HotSpotTapListener hotSpotTapListener) {
        Path path = this.mCoordinateTranslater.pathFromPositions(list, true);
        RectF rectF = new RectF();
        path.computeBounds(rectF, true);
        Rect rect = new Rect();
        rectF.round(rect);
        Region region = new Region(rect);
        HotSpot hotSpot = new HotSpot();
        hotSpot.setPath(path, region);
        hotSpot.setHotSpotTapListener(hotSpotTapListener);
        return this.addHotSpot(hotSpot);
    }

    public void removeHotSpot(HotSpot hotSpot) {
        this.mHotSpotManager.removeHotSpot(hotSpot);
    }

    public void setHotSpotTapListener(HotSpot.HotSpotTapListener hotSpotTapListener) {
        this.mHotSpotManager.setHotSpotTapListener(hotSpotTapListener);
    }

    public CompositePathView.DrawablePath drawPath(CompositePathView.DrawablePath drawablePath) {
        return this.mCompositePathView.addPath(drawablePath);
    }

    public CompositePathView.DrawablePath drawPath(List list, Paint paint) {
        Path path = this.mCoordinateTranslater.pathFromPositions(list, false);
        return this.mCompositePathView.addPath(path, paint);
    }

    public void removePath(CompositePathView.DrawablePath drawablePath) {
        this.mCompositePathView.removePath(drawablePath);
    }

    public Paint getDefaultPathPaint() {
        return this.mCompositePathView.getDefaultPaint();
    }

    public void pause() {
        this.mRenderThrottleHandler.clear();
        this.mDetailLevelManager.invalidateAll();
        this.setWillNotDraw(true);
    }

    public void destroy() {
        this.pause();
        this.mTileCanvasViewGroup.destroy();
        this.mCompositePathView.clear();
        this.removeAllViews();
    }

    public void resume() {
        this.setWillNotDraw(false);
        this.updateViewport();
        this.mTileCanvasViewGroup.updateTileSet(this.mDetailLevelManager.getCurrentDetailLevel());
        this.requestRender();
        this.requestLayout();
    }

    public void setShouldRenderWhilePanning(boolean bl) {
        this.mShouldRenderWhilePanning = bl;
        int n = bl ? 15 : 250;
        this.mTileCanvasViewGroup.setRenderBuffer(n);
    }

    public void setShouldUpdateDetailLevelWhileZooming(boolean bl) {
        this.mShouldUpdateDetailLevelWhileZooming = bl;
    }

    public void setDetailLevelManager(DetailLevelManager detailLevelManager) {
        this.mDetailLevelManager = detailLevelManager;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.updateViewport();
        this.requestRender();
    }

    protected void updateViewport() {
        int n = this.getScrollX();
        int n2 = this.getScrollY();
        int n3 = n + this.getWidth();
        int n4 = n2 + this.getHeight();
        this.mDetailLevelManager.updateViewport(n, n2, n3, n4);
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        super.onScrollChanged(n, n2, n3, n4);
        this.updateViewport();
        if (this.mShouldRenderWhilePanning) {
            this.requestRender();
        } else {
            this.requestThrottledRender();
        }
    }

    @Override
    public void onScaleChanged(float f, float f2) {
        super.onScaleChanged(f, f2);
        this.mDetailLevelManager.setScale(f);
        this.mHotSpotManager.setScale(f);
        this.mTileCanvasViewGroup.setScale(f);
        this.mScalingLayout.setScale(f);
        this.mCompositePathView.setScale(f);
        this.mMarkerLayout.setScale(f);
        this.mCalloutLayout.setScale(f);
    }

    @Override
    public void onPanBegin(int n, int n2, ZoomPanLayout.ZoomPanListener.Origination origination) {
        this.suppressRender();
    }

    @Override
    public void onPanUpdate(int n, int n2, ZoomPanLayout.ZoomPanListener.Origination origination) {
    }

    @Override
    public void onPanEnd(int n, int n2, ZoomPanLayout.ZoomPanListener.Origination origination) {
        this.requestRender();
    }

    @Override
    public void onZoomBegin(float f, ZoomPanLayout.ZoomPanListener.Origination origination) {
        if (!this.mShouldUpdateDetailLevelWhileZooming) {
            this.mDetailLevelManager.lockDetailLevel();
        }
        this.mDetailLevelManager.setScale(f);
    }

    @Override
    public void onZoomUpdate(float f, ZoomPanLayout.ZoomPanListener.Origination origination) {
    }

    @Override
    public void onZoomEnd(float f, ZoomPanLayout.ZoomPanListener.Origination origination) {
        this.mDetailLevelManager.unlockDetailLevel();
        this.mDetailLevelManager.setScale(f);
        this.requestRender();
    }

    @Override
    public void onDetailLevelChanged(DetailLevel detailLevel) {
        this.requestRender();
        this.mTileCanvasViewGroup.updateTileSet(detailLevel);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
        int n = (int)((float)this.getScrollX() + motionEvent.getX());
        int n2 = (int)((float)this.getScrollY() + motionEvent.getY());
        this.mMarkerLayout.processHit(n, n2);
        this.mHotSpotManager.processHit(n, n2);
        return super.onSingleTapConfirmed(motionEvent);
    }

    @Override
    public void onRenderStart() {
    }

    @Override
    public void onRenderCancelled() {
    }

    @Override
    public void onRenderComplete() {
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        savedState.mScale = this.getScale();
        savedState.mSavedCenterX = this.getScrollX() + this.getHalfWidth();
        savedState.mSavedCenterY = this.getScrollY() + this.getHalfHeight();
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        final SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setScale(savedState.mScale);
        this.post(new Runnable(){

            @Override
            public void run() {
                TileView.this.scrollToAndCenter(savedState.mSavedCenterX, savedState.mSavedCenterY);
            }
        });
    }

    private static class SavedState
    extends View.BaseSavedState {
        float mScale;
        int mSavedCenterX;
        int mSavedCenterY;
        public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.mScale = parcel.readFloat();
            this.mSavedCenterX = parcel.readInt();
            this.mSavedCenterY = parcel.readInt();
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeFloat(this.mScale);
            parcel.writeInt(this.mSavedCenterX);
            parcel.writeInt(this.mSavedCenterY);
        }
    }

    private static class RenderThrottleHandler
    extends Handler {
        private static final int MESSAGE = 0;
        private static final int RENDER_THROTTLE_TIMEOUT = 100;
        private final WeakReference mTileViewWeakReference;

        public RenderThrottleHandler(TileView tileView) {
            this.mTileViewWeakReference = new WeakReference<TileView>(tileView);
        }

        public void handleMessage(Message message) {
            TileView tileView = (TileView)this.mTileViewWeakReference.get();
            if (tileView != null) {
                tileView.requestSafeRender();
            }
        }

        public void clear() {
            if (this.hasMessages(0)) {
                this.removeMessages(0);
            }
        }

        public void submit() {
            this.clear();
            this.sendEmptyMessageDelayed(0, 100L);
        }
    }
}

