/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ui.webdriver.ByAny;
import com.qmetry.qaf.automation.ui.webdriver.ByCustom;
import com.qmetry.qaf.automation.ui.webdriver.ByExtCompQuery;
import com.qmetry.qaf.automation.ui.webdriver.ByExtDomQuery;
import com.qmetry.qaf.automation.ui.webdriver.ByJQuery;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.openqa.selenium.By;

public class LocatorUtil {
    public static String getXPathLoc(String id) {
        return "//*[@id='" + id + "']";
    }

    public static String getCssLoc(String id) {
        return "css=*#" + id;
    }

    public static String getDescription(String locator) {
        if (JSONUtil.isValidJsonString(locator)) {
            try {
                Map<String, Object> map = JSONUtil.toMap(locator);
                return map.containsKey("desc") ? (String)map.get("desc") : (map.containsKey("description") ? (String)map.get("description") : (String)map.get("locator"));
            }
            catch (JSONException jSONException) {}
        }
        return locator;
    }

    public static By getBy(String loc) {
        return LocatorUtil.getBy(loc, ConfigurationManager.getBundle());
    }

    public static By getBy(String loc, PropertyUtil props) {
        Gson gson = new Gson();
        loc = props.getSubstitutor().replace(loc);
        JsonElement element = JSONUtil.getGsonElement(loc = props.getString(loc, loc));
        if (element != null && element.isJsonObject()) {
            Object obj = ((Map)gson.fromJson(element, Map.class)).get("locator");
            String string = loc = obj instanceof String ? (String)obj : gson.toJson(obj);
        }
        if ((element = JSONUtil.getGsonElement(loc)) != null && element.isJsonArray()) {
            String[] locs = (String[])new Gson().fromJson(element, String[].class);
            return new ByAny(locs);
        }
        if (loc.startsWith("//")) {
            return By.xpath((String)loc);
        }
        if (loc.indexOf("=") > 0) {
            String[] parts = loc.split("=", 2);
            if (parts[0].equalsIgnoreCase("key") || parts[0].equalsIgnoreCase("property")) {
                String val = props.getSubstitutor().replace(parts[1]);
                return LocatorUtil.getBy(props.getString(val, val), props);
            }
            if (parts[0].equalsIgnoreCase("jquery")) {
                return new ByJQuery(parts[1]);
            }
            if (parts[0].equalsIgnoreCase("extDom")) {
                return new ByExtDomQuery(parts[1]);
            }
            if (parts[0].equalsIgnoreCase("extComp")) {
                return new ByExtCompQuery(parts[1]);
            }
            if (parts[0].equalsIgnoreCase("name")) {
                return By.name((String)parts[1]);
            }
            if (parts[0].equalsIgnoreCase("id")) {
                return By.id((String)parts[1]);
            }
            if (parts[0].equalsIgnoreCase("xpath")) {
                return By.xpath((String)parts[1]);
            }
            if (parts[0].equalsIgnoreCase("css")) {
                return By.cssSelector((String)parts[1]);
            }
            if (parts[0].equalsIgnoreCase("link") || parts[0].equalsIgnoreCase("linkText")) {
                return By.linkText((String)parts[1]);
            }
            if (parts[0].equalsIgnoreCase("partialLink") || parts[0].equalsIgnoreCase("partialLinkText")) {
                return By.partialLinkText((String)parts[1]);
            }
            if (parts[0].equalsIgnoreCase("className")) {
                return By.className((String)parts[1]);
            }
            if (parts[0].equalsIgnoreCase("tagName")) {
                return By.tagName((String)parts[1]);
            }
            return new ByCustom(parts[0], parts[1]);
        }
        return By.xpath((String)String.format("//*[@name='%s' or @id='%s' or @value='%s']", loc, loc, loc));
    }

    private static String parseParameters(String str) {
        try {
            Pattern p = Pattern.compile("\\$\\{([^}]+)\\}", 8);
            Matcher m = p.matcher(str);
            while (m.find()) {
                String param = m.group(1);
                if (!ConfigurationManager.getBundle().containsKey(param)) continue;
                str = str.replaceAll("\\$\\{" + param + "\\}", ConfigurationManager.getBundle().getString(param));
            }
        }
        catch (Exception e) {
            System.err.println("Unable to parse: " + str);
            e.printStackTrace();
        }
        return str;
    }
}

