/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.testng.DataProviderException;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class CSVUtil {
    private static final Log logger = LogFactoryImpl.getLog(CSVUtil.class);

    public static List<Object[]> getCSVData(String strFile) {
        return CSVUtil.getCSVData(strFile, ',');
    }

    public static List<Object[]> getCSVData(String strFile, char separatorChar) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        BufferedReader br = null;
        try {
            try {
                logger.info((Object)("loading csv data file: " + strFile));
                File csvFile = new File(strFile);
                br = new BufferedReader(new FileReader(csvFile));
                String strLine = "";
                while ((strLine = br.readLine()) != null) {
                    if (!"".equalsIgnoreCase(strLine.trim()) && !"#!".contains("" + strLine.trim().charAt(0))) {
                        Object[] cols = StringUtil.parseCSV(strLine, separatorChar);
                        rows.add(cols);
                        continue;
                    }
                    if (!strLine.contains("col.separator")) continue;
                    separatorChar = strLine.split("=")[1].trim().charAt(0);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Exception while reading csv file: " + strFile + e));
                throw new DataProviderException("Error while fetching data from " + strFile, e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rows;
    }

    @Deprecated
    public static List<Object[]> getCSVData(String strFile, Map<String, Integer> headers) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int cnt = 0;
        BufferedReader br = null;
        try {
            try {
                logger.info((Object)("loading csv data file: " + strFile));
                File csvFile = new File(strFile);
                br = new BufferedReader(new FileReader(csvFile));
                String strLine = "";
                char separatorChar = ',';
                while ((strLine = br.readLine()) != null) {
                    if (!"".equalsIgnoreCase(strLine.trim()) && !"#!".contains("" + strLine.trim().charAt(0))) {
                        Object[] cols = StringUtil.parseCSV(strLine, separatorChar);
                        if (cnt == 0) {
                            int i = 0;
                            while (i < cols.length) {
                                headers.put(cols[i].toString().replaceAll(" ", "").toUpperCase(), i);
                                ++i;
                            }
                        } else {
                            rows.add(cols);
                        }
                        ++cnt;
                        continue;
                    }
                    if (!strLine.contains("col.separator")) continue;
                    separatorChar = strLine.split("=")[1].trim().charAt(0);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Exception while reading csv file: " + strFile + e));
                throw new DataProviderException("Error while fetching data from " + strFile, e);
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        logger.info((Object)(String.valueOf(cnt) + " rows found"));
        return rows;
    }

    public static List<Object[]> getCSVDataAsMap(String strFile) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        BufferedReader br = null;
        try {
            try {
                logger.info((Object)("loading csv data file: " + strFile));
                File csvFile = new File(strFile);
                br = new BufferedReader(new FileReader(csvFile));
                String strLine = "";
                char separatorChar = ',';
                Object[] colsNames = null;
                while ((strLine = br.readLine()) != null) {
                    if (!"".equalsIgnoreCase(strLine.trim()) && !"#!".contains("" + strLine.trim().charAt(0))) {
                        if (colsNames == null) {
                            colsNames = StringUtil.parseCSV(strLine, separatorChar);
                            continue;
                        }
                        Object[] cols = StringUtil.parseCSV(strLine, separatorChar);
                        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                        int i = 0;
                        while (i < cols.length) {
                            try {
                                map.put(colsNames[i].toString().trim(), cols[i]);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                logger.warn((Object)String.format("Missing column header for column[%d] in data file: %s. It will be included by lineNo", i + 1, strFile));
                                map.put(String.valueOf(i), cols[i]);
                            }
                            ++i;
                        }
                        rows.add(new Object[]{map});
                        continue;
                    }
                    if (!strLine.contains("col.separator")) continue;
                    separatorChar = strLine.split("=")[1].trim().charAt(0);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Exception while reading csv file: " + strFile + e));
                throw new DataProviderException("Error while fetching data from " + strFile, e);
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return rows;
    }
}

