/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.TimeoutException;

public class DynamicWait<T> {
    private T input;
    private long timeout = DynamicWait.getDefaultTimeout();
    private long interval = DynamicWait.getDefaultTimeout();
    private Supplier<String> messageSupplier = new StringSupplier(null);
    private List<Class<? extends Throwable>> ignoredExceptions = Lists.newLinkedList();

    public DynamicWait(T input) {
        this.input = Preconditions.checkNotNull(input);
    }

    public DynamicWait<T> withMessage(String message) {
        this.messageSupplier = new StringSupplier(message);
        return this;
    }

    public DynamicWait<T> withMessage(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
        return this;
    }

    public DynamicWait<T> pollingEvery(long duration, TimeUnit unit) {
        this.interval = DynamicWait.duration(duration, unit);
        return this;
    }

    public void until(final Predicate<T> isTrue) {
        this.until(new Function<T, Boolean>(){

            public Boolean apply(T input) {
                return isTrue.apply(input);
            }

            public String toString() {
                return isTrue.toString();
            }
        });
    }

    public <V> V until(Function<? super T, V> isTrue) {
        long end = this.laterBy(this.timeout);
        Throwable lastException = null;
        while (true) {
            try {
                Object value = isTrue.apply(this.input);
                if (value != null && Boolean.class.equals(value.getClass()) ? Boolean.TRUE.equals(value) : value != null) {
                    return (V)value;
                }
            }
            catch (Throwable e) {
                lastException = this.propagateIfNotIgnored(e);
            }
            if (!this.isNowBefore(end)) {
                String message = this.messageSupplier != null ? (String)this.messageSupplier.get() : null;
                String toAppend = message == null ? " waiting for " + isTrue.toString() : ": " + message;
                String timeoutMessage = String.format("Timed out after %d seconds%s", TimeUnit.SECONDS.convert(this.timeout, TimeUnit.MILLISECONDS), toAppend);
                throw new TimeoutException(timeoutMessage, lastException);
            }
            QAFTestBase.pause(this.interval);
        }
    }

    public DynamicWait<T> withTimeout(long duration, TimeUnit unit) {
        this.timeout = DynamicWait.duration(duration, unit);
        return this;
    }

    private Throwable propagateIfNotIgnored(Throwable e) {
        for (Class<? extends Throwable> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        throw Throwables.propagate((Throwable)e);
    }

    @SafeVarargs
    public final DynamicWait<T> ignoring(Class<? extends Throwable> ... types) {
        this.ignoredExceptions.addAll(Arrays.asList(types));
        return this;
    }

    public static long getDefaultTimeout() {
        return ConfigurationManager.getBundle().getLong("selenium.explicit.wait.timeout", ApplicationProperties.SELENIUM_WAIT_TIMEOUT.getIntVal(5000));
    }

    public static long getDefaultInterval() {
        return ConfigurationManager.getBundle().getLong("selenium.explicit.wait.interval", ConfigurationManager.getBundle().getLong("selenium.wait.interval", 1000L));
    }

    private long laterBy(long durationInMillis) {
        return this.now() + durationInMillis;
    }

    private boolean isNowBefore(long endInMillis) {
        return this.now() < endInMillis;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public static long duration(long time, TimeUnit unit) {
        return unit.convert(time, TimeUnit.MILLISECONDS);
    }

    private static class StringSupplier
    implements Supplier<String> {
        String message;

        public StringSupplier(String message) {
            this.message = message;
        }

        public String get() {
            return this.message;
        }
    }
}

