/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium.webdriver;

import com.qmetry.qaf.automation.ui.selenium.QAFCommandProcessor;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandListener;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandTracker;
import com.qmetry.qaf.automation.ui.selenium.webdriver.AddScriptCommand;
import com.qmetry.qaf.automation.ui.selenium.webdriver.DriverSkippedCommand;
import com.qmetry.qaf.automation.ui.selenium.webdriver.GetCssCountCommand;
import com.qmetry.qaf.automation.ui.selenium.webdriver.GetText;
import com.qmetry.qaf.automation.ui.selenium.webdriver.SetAttributeCommand;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.WebDriverCommandProcessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.ScreenshotException;

public class QAFWebDriverCommandProcessor
extends WebDriverCommandProcessor
implements QAFCommandProcessor {
    private transient List<SeleniumCommandListener> commandListeners = new ArrayList<SeleniumCommandListener>();
    private boolean invokingListener;

    public QAFWebDriverCommandProcessor(String baseUrl, QAFExtendedWebDriver driver) {
        super(baseUrl, (WebDriver)driver);
        this.addISExtenedCommands();
    }

    public String extractScreenShot(WebDriverException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ScreenshotException) {
            return ((ScreenshotException)cause).getBase64EncodedScreenshot();
        }
        return null;
    }

    public String doCommand(String commandName, String[] args) {
        SeleniumCommandTracker commandTracker = new SeleniumCommandTracker(commandName, args);
        this.invokeBeforeCommand(commandTracker);
        if (commandTracker.getResult() == null) {
            try {
                String[] argsToPass = commandTracker.getArgs();
                String result = super.doCommand(commandName, argsToPass);
                commandTracker.setResult(result);
            }
            catch (SeleniumException e) {
                System.out.println("Error in caught doCommand: " + commandName);
                commandTracker.setException((RuntimeException)((Object)e));
            }
        }
        this.invokeAfterCommand(commandTracker);
        if (commandTracker.hasException()) {
            throw commandTracker.getException();
        }
        return commandTracker.getResult();
    }

    public void start(String strOptions) {
    }

    private void invokeBeforeCommand(SeleniumCommandTracker commandTracker) {
        if (!this.invokingListener) {
            this.invokingListener = true;
            for (SeleniumCommandListener listener : this.commandListeners) {
                try {
                    listener.beforeCommand(this, commandTracker);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            this.invokingListener = false;
        }
    }

    private void invokeAfterCommand(SeleniumCommandTracker commandTracker) {
        if (!this.invokingListener) {
            this.invokingListener = true;
            for (SeleniumCommandListener listener : this.commandListeners) {
                try {
                    listener.afterCommand(this, commandTracker);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            this.invokingListener = false;
        }
    }

    @Override
    public void addListener(String ... listenerClasses) {
        if (listenerClasses != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            String[] stringArray = listenerClasses;
            int n = listenerClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String listenerClass = stringArray[n2];
                try {
                    if (!StringUtils.isEmpty((String)listenerClass)) {
                        Class<?> cls = loader.loadClass(listenerClass);
                        SeleniumCommandListener listener = (SeleniumCommandListener)cls.newInstance();
                        this.commandListeners.add(listener);
                    }
                }
                catch (Throwable e) {
                    System.err.println("unable to register" + listenerClass + " as SeleniumCommandListener: " + e.getMessage());
                }
                ++n2;
            }
        }
    }

    @Override
    public void addListener(SeleniumCommandListener listener) {
        if (listener != null) {
            this.commandListeners.add(listener);
        }
    }

    private void addISExtenedCommands() {
        JavascriptLibrary javascriptLibrary = new JavascriptLibrary();
        ElementFinder elementFinder = new ElementFinder(javascriptLibrary);
        this.addMethod("shutDownSeleniumServer", new DriverSkippedCommand());
        this.addMethod("retrieveLastRemoteControlLogs", new DriverSkippedCommand());
        this.addMethod("addScript", new AddScriptCommand());
        this.addMethod("setAttribute", new SetAttributeCommand(javascriptLibrary, elementFinder));
        this.addMethod("getCssCount", new GetCssCountCommand());
        this.addMethod("getText", new GetText(elementFinder));
    }

    public QAFExtendedWebDriver getWrappedDriver() {
        return (QAFExtendedWebDriver)super.getWrappedDriver();
    }
}

