/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ui.AbstractTestCase;
import com.qmetry.qaf.automation.ui.api.PageLocator;
import com.qmetry.qaf.automation.ui.api.TestPage;
import com.qmetry.qaf.automation.ui.api.UiTestBase;
import com.qmetry.qaf.automation.ui.webdriver.ElementFactory;
import com.qmetry.qaf.automation.util.PropertyUtil;
import java.lang.reflect.ParameterizedType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public abstract class AbstractTestPage<P extends TestPage<D>, D>
implements TestPage<D> {
    protected P parent;
    protected UiTestBase<D> testbase;
    protected D driver;
    protected PropertyUtil pageProps;
    protected PageLocator pageLocator;
    protected Object[] launchArguments;
    protected final Log logger;
    protected TestPage.LaunchStrategy launchStrategy = TestPage.LaunchStrategy.onlyIfRequired;

    public AbstractTestPage(UiTestBase<D> testBase) {
        this.testbase = testBase;
        this.logger = LogFactoryImpl.getLog(this.getClass());
        this.driver = this.testbase.getDriver();
        this.pageProps = ConfigurationManager.getBundle();
        this.initWebElements();
    }

    public AbstractTestPage(UiTestBase<D> testBase, P parent2) {
        this(testBase);
        this.parent = parent2;
    }

    @Override
    public UiTestBase<D> getTestBase() {
        return this.testbase;
    }

    @Override
    public PageLocator getPageLocator() {
        return this.pageLocator;
    }

    @Override
    public void setLaunchStrategy(TestPage.LaunchStrategy strategy) {
        this.launchStrategy = strategy;
    }

    @Override
    public void launchPage(PageLocator locator, Object ... args) {
        this.pageLocator = locator;
        this.launchArguments = args;
        boolean reqToLaunch = false;
        this.parent = this.getParent();
        try {
            reqToLaunch = !this.launchStrategy.equals((Object)TestPage.LaunchStrategy.onlyIfRequired) || !this.isPageActive(locator, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reqToLaunch) {
            this.logger.debug((Object)("Launching page: " + this.getClass().getCanonicalName()));
            if (this.parent != null) {
                if (this.launchStrategy.equals((Object)TestPage.LaunchStrategy.alwaysRelaunchFromRoot)) {
                    this.parent.setLaunchStrategy(this.launchStrategy);
                } else {
                    this.parent.setLaunchStrategy(TestPage.LaunchStrategy.onlyIfRequired);
                }
                this.parent.launchPage(locator != null ? locator.getParentLocator() : null, args);
            }
            this.beforeLaunch(args);
            this.openPage(locator, args);
            this.waitForPageToLoad();
            this.afterLaunch();
        }
    }

    public void waitForPageToLoad() {
    }

    @Override
    public boolean isPageActive(PageLocator loc, Object ... args) {
        return false;
    }

    protected void afterLaunch() {
    }

    protected void beforeLaunch(Object ... args) {
    }

    protected void initParent() {
        try {
            Class class1 = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            if (!class1.isInterface()) {
                this.parent = (TestPage)class1.newInstance();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unable to init parent class" + e.getMessage()));
        }
    }

    protected abstract void openPage(PageLocator var1, Object ... var2);

    public final P getParent() {
        if (this.parent == null) {
            this.initParent();
        }
        return this.parent;
    }

    private void initWebElements() {
        ElementFactory elementFactory = new ElementFactory();
        elementFactory.initFields(this);
    }

    public void assertActive() {
        String msg = String.format("Expected %s is active.", this.getClass().getSimpleName());
        AbstractTestCase.assertTrue(this.isPageActive(this.pageLocator, this.launchArguments), msg, msg);
    }

    @Deprecated
    public void waitForImageToLoad(String imgLoc) {
    }

    public void waitForAjaxToComplete() {
    }
}

