/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.testng.TestNGTestCase;
import com.qmetry.qaf.automation.ui.api.UiTestBase;
import com.qmetry.qaf.automation.util.PropertyUtil;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;

public abstract class AbstractTestCase<D, B extends UiTestBase<D>>
extends TestNGTestCase {
    protected PropertyUtil props = ConfigurationManager.getBundle();

    public abstract B getTestBase();

    public D getDriver() {
        return this.getTestBase().getDriver();
    }

    @AfterMethod(alwaysRun=true)
    public final void afterMethod(ITestContext testContext, ITestResult tr) {
        this.tearDownPrrallelThreads(testContext, "m");
    }

    @AfterGroups(alwaysRun=true)
    public final void afterGroup(ITestContext testContext) {
        this.tearDownPrrallelThreads(testContext, "groups");
    }

    @AfterClass(alwaysRun=true)
    public final void afterClass(ITestContext testContext) {
        this.tearDownPrrallelThreads(testContext, "classes");
    }

    @AfterTest(alwaysRun=true)
    public final void afterTest(ITestContext testContext) {
        this.tearDownPrrallelThreads(testContext, "tests");
    }

    private void tearDownPrrallelThreads(ITestContext testContext, String type) {
        String useSingleSeleniumInstance = ConfigurationManager.getBundle().getString("selenium.singletone", "t");
        if ((useSingleSeleniumInstance.toUpperCase().startsWith(type.substring(0, 1).toUpperCase()) || type.equalsIgnoreCase("tests")) && this.getTestBase() != null) {
            this.getTestBase().tearDown();
        }
    }
}

