/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.pro;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.integration.ResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.client.TestNGScenario;
import com.qmetry.qaf.automation.testng.RetryAnalyzer;
import com.qmetry.qaf.automation.testng.dataprovider.DataProviderUtil;
import com.qmetry.qaf.automation.testng.pro.QAFTestNGListener;
import com.qmetry.qaf.automation.testng.report.ReporterUtil;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.IInvokedMethod;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Parameters;

public class QAFTestNGListener2
extends QAFTestNGListener {
    private final Log logger = LogFactoryImpl.getLog(this.getClass());

    public QAFTestNGListener2() {
        this.logger.debug((Object)"QAFTestNGListener registered!...");
    }

    @Override
    public void onStart(ISuite suite) {
        if (this.skipReporting()) {
            return;
        }
        super.onStart(suite);
        ReporterUtil.createMetaInfo(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        if (this.skipReporting()) {
            return;
        }
        super.onFinish(suite);
        this.logger.debug((Object)"onFinish: start");
        ReporterUtil.createMetaInfo(suite);
        this.logger.debug((Object)"onFinish: done");
    }

    @Override
    public void onStart(ITestContext testContext) {
        super.onStart(testContext);
        if (!this.skipReporting()) {
            ReporterUtil.updateOverview(testContext, null);
        }
    }

    @Override
    public void onFinish(ITestContext testContext) {
        if (this.skipReporting()) {
            return;
        }
        super.onFinish(testContext);
        ReporterUtil.updateOverview(testContext, null);
    }

    public void transform(ITestAnnotation testAnnotation, Class clazz, Constructor arg2, Method method) {
        try {
            if (method != null) {
                String tmtURL;
                if (method.getParameterTypes() != null && method.getParameterTypes().length > 0 && !method.isAnnotationPresent(Parameters.class)) {
                    DataProviderUtil.setQAFDataProvider(testAnnotation, method);
                }
                if (StringUtil.isNotBlank((String)(tmtURL = ConfigurationManager.getBundle().getString(String.valueOf(method.getName()) + ".testspec.url")))) {
                    String desc = String.format("%s<br/><a href=\"%s\">[test-spec]</a>", testAnnotation.getDescription(), tmtURL);
                    testAnnotation.setDescription(desc);
                }
                if (ConfigurationManager.getBundle().getBoolean("report.javadoc.link", false)) {
                    String linkRelPath = String.format("%s%s.html#%s", ConfigurationManager.getBundle().getString("javadoc.folderpath", "../../../docs/tests/"), method.getDeclaringClass().getCanonicalName().replaceAll("\\.", "/"), ClassUtil.getMethodSignture(method, false));
                    String desc = String.format("%s " + ConfigurationManager.getBundle().getString("report.javadoc.link.format", "<a href=\"%s\" target=\"_blank\">[View-doc]</a>"), testAnnotation.getDescription(), linkRelPath);
                    testAnnotation.setDescription(desc);
                }
                testAnnotation.setDescription(ConfigurationManager.getBundle().getSubstitutor().replace(testAnnotation.getDescription()));
                testAnnotation.setRetryAnalyzer(Class.forName(ApplicationProperties.RETRY_ANALYZER.getStringVal(RetryAnalyzer.class.getName())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult tr, ITestContext context) {
        super.afterInvocation(method, tr, context);
    }

    @Override
    protected void report(ITestResult tr) {
        super.report(tr);
        if (!ConfigurationManager.getBundle().getBoolean("cucumber.run.mode", false)) {
            this.deployResult(tr);
            if (!ConfigurationManager.getBundle().getBoolean("disable.qaf.testng.reporter", false)) {
                QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
                ArrayList<CheckpointResultBean> checkpoints = new ArrayList<CheckpointResultBean>(stb.getCheckPointResults());
                ArrayList<LoggingBean> logs = new ArrayList<LoggingBean>(stb.getLog());
                ITestContext testContext = (ITestContext)tr.getAttribute("context");
                ReporterUtil.createMethodResult(testContext, tr, logs, checkpoints);
            }
        }
        if (tr.getStatus() != 3) {
            ConfigurationManager.getBundle().clearProperty(RetryAnalyzer.RETRY_INVOCATION_COUNT);
        }
    }

    private void deployResult(ITestResult tr) {
        try {
            if (ResultUpdator.getResultUpdatorsCnt() > 0 && tr.getMethod() instanceof TestNGScenario && (tr.getStatus() == 2 || tr.getStatus() == 1 || tr.getStatus() == 3)) {
                TestCaseRunResult.Status status = tr.getStatus() == 1 ? TestCaseRunResult.Status.PASS : (tr.getStatus() == 2 ? TestCaseRunResult.Status.FAIL : TestCaseRunResult.Status.SKIPPED);
                TestNGScenario scenario = (TestNGScenario)tr.getMethod();
                HashMap<String, Object> params2 = new HashMap<String, Object>(scenario.getMetaData());
                params2.put("duration", tr.getEndMillis() - tr.getStartMillis());
                HashMap<String, Object> executionInfo = new HashMap<String, Object>();
                executionInfo.put("testName", tr.getTestContext().getCurrentXmlTest().getName());
                executionInfo.put("suiteName", tr.getTestContext().getSuite().getName());
                HashMap runPrams = new HashMap(tr.getTestContext().getCurrentXmlTest().getAllParameters());
                runPrams.putAll(ConfigurationConverter.getMap((Configuration)ConfigurationManager.getBundle().subset("env")));
                executionInfo.put("env", runPrams);
                int retryCount = ConfigurationManager.getBundle().getInt(RetryAnalyzer.RETRY_INVOCATION_COUNT, 0);
                boolean willRetry = ConfigurationManager.getBundle().getBoolean(RetryAnalyzer.WILL_RETRY, false);
                ConfigurationManager.getBundle().clearProperty(RetryAnalyzer.WILL_RETRY);
                if (retryCount > 0) {
                    executionInfo.put("retryCount", retryCount);
                }
                TestCaseRunResult testCaseRunResult = new TestCaseRunResult(status, scenario.getMetaData(), tr.getParameters(), executionInfo, scenario.getSteps(), tr.getStartMillis(), willRetry, scenario.isTest());
                testCaseRunResult.setClassName(scenario.getClassOrFileName());
                if (scenario.getGroups() != null && scenario.getGroups().length > 0) {
                    testCaseRunResult.getMetaData().put("groups", scenario.getGroups());
                }
                testCaseRunResult.getMetaData().put("description", scenario.getDescription());
                testCaseRunResult.setThrowable(tr.getThrowable());
                ResultUpdator.updateResult(testCaseRunResult);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to deploy result", (Throwable)e);
        }
    }

    private boolean skipReporting() {
        return ConfigurationManager.getBundle().getBoolean("disable.qaf.testng.reporter", false) || ConfigurationManager.getBundle().getBoolean("cucumber.run.mode", false);
    }
}

