/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.pro;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.HtmlCheckpointResultFormatter;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.text.BDDTestFactory;
import com.qmetry.qaf.automation.testng.MethodPriorityComparator;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.IInvokedMethod;
import org.testng.IMethodInstance;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlMethodSelectors;
import org.testng.xml.XmlScript;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class QAFTestNGListener {
    private final Log logger = LogFactoryImpl.getLog(this.getClass());

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
        try {
            this.generateTestFailedXML(suite);
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getStackTrace());
            this.logger.info((Object)"Unable to create testng-failed-qas.xml");
        }
    }

    public void onTestStart(ITestResult paramITestResult) {
        this.logger.debug((Object)"onTestStart: start");
    }

    public void onStart(ITestContext testContext) {
    }

    public void onFinish(ITestContext testContext) {
        this.logger.debug((Object)"onfinish testcntext: start");
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.onTestFailure(tr);
    }

    public void onTestFailure(ITestResult tr) {
        this.report(tr);
    }

    public void onTestSkipped(ITestResult tr) {
        this.report(tr);
    }

    public void onTestSuccess(ITestResult tr) {
        this.report(tr);
    }

    public void onConfigurationFailure(ITestResult itr) {
        this.report(itr);
    }

    public void onConfigurationSkip(ITestResult itr) {
        if (!itr.getMethod().getConstructorOrMethod().getDeclaringClass().getPackage().getName().startsWith("com.qmetry.qaf.automation")) {
            this.report(itr);
        }
    }

    public void onConfigurationSuccess(ITestResult itr) {
        if (!itr.getMethod().getConstructorOrMethod().getDeclaringClass().getPackage().getName().startsWith("com.qmetry.qaf.automation")) {
            this.report(itr);
        }
    }

    public void transform(IDataProviderAnnotation arg0, Method method) {
        boolean parallel = false;
        parallel = ConfigurationManager.getBundle().containsKey(String.valueOf(method.getName()) + ".parallel") ? ConfigurationManager.getBundle().getBoolean(String.valueOf(method.getName()) + ".parallel") : ConfigurationManager.getBundle().getBoolean("global.datadriven.parallel", false);
        arg0.setParallel(parallel);
    }

    public void transform(IFactoryAnnotation factory, Method method) {
    }

    public void transform(IConfigurationAnnotation iConfigurationAnnotation, Class arg1, Constructor arg2, Method arg3) {
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> lst, ITestContext context) {
        this.logger.debug((Object)"Method Order interceptor called");
        String order = context.getCurrentXmlTest().getParameter("groupOrder");
        MethodPriorityComparator comparator = new MethodPriorityComparator(order);
        Collections.sort(lst, comparator);
        return lst;
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult tr, ITestContext context) {
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        stb.getLog().clear();
        stb.clearVerificationErrors();
        stb.getCheckPointResults().clear();
        this.logger.debug((Object)("beforeInvocation: " + method.getTestMethod().getMethodName()));
        tr.setAttribute("context", (Object)context);
        ConfigurationManager.getBundle().setProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        ConfigurationManager.getBundle().setProperty(ApplicationProperties.CURRENT_TEST_NAME.key, tr.getName());
        ConfigurationManager.getBundle().setProperty(ApplicationProperties.CURRENT_TEST_DESCRIPTION.key, tr.getMethod().getDescription());
        ConfigurationManager.getBundle().setProperty(ApplicationProperties.CURRENT_TEST_RESULT.key, tr);
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult tr) {
    }

    public void afterInvocation(IInvokedMethod method, ITestResult tr) {
    }

    public void afterInvocation(IInvokedMethod method, ITestResult tr, ITestContext context) {
        this.logger.debug((Object)("afterInvocation: " + method.getTestMethod().getMethodName() + " - " + method.getTestMethod().getConstructorOrMethod().getDeclaringClass().getName() + " is test:" + method.isTestMethod()));
        this.processResult(tr, context);
        this.logger.debug((Object)"afterInvocation: Done");
    }

    public CheckpointResultBean getLastFailedCheckpointResultBean(List<CheckpointResultBean> checkPointResults) {
        if (checkPointResults == null || checkPointResults.isEmpty()) {
            return null;
        }
        int index = checkPointResults.size() - 1;
        while (index >= 0) {
            CheckpointResultBean checkpointResultBean = checkPointResults.get(index);
            MessageTypes type = MessageTypes.valueOf(checkpointResultBean.getType());
            if (type.isFailure()) {
                return checkpointResultBean;
            }
            --index;
        }
        return null;
    }

    protected void report(ITestResult tr) {
        String[] groups = tr.getMethod().getGroups();
        if (groups != null && Arrays.asList(groups).contains("cucumber")) {
            return;
        }
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        tr.setAttribute("browser", (Object)stb.getBrowser());
        Reporter.setCurrentTestResult((ITestResult)tr);
        if (ConfigurationManager.getBundle().getBoolean("report.log.testngoutput", false)) {
            HtmlCheckpointResultFormatter checkpointResultFormatter = new HtmlCheckpointResultFormatter();
            Reporter.log((String)checkpointResultFormatter.getResults(stb.getCheckPointResults()));
        }
    }

    protected void processResult(ITestResult tr, ITestContext context) {
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        if (stb.getVerificationErrors() > 0 && tr.getStatus() == 1) {
            this.setFailure(tr, context);
        }
        if (tr.getStatus() == 2) {
            String failiremsg = this.getFailureMessage(tr.getThrowable());
            CheckpointResultBean lastFailedChkPoint = this.getLastFailedCheckpointResultBean(stb.getCheckPointResults());
            if (lastFailedChkPoint != null) {
                if (StringUtil.isBlank((String)lastFailedChkPoint.getScreenshot())) {
                    CheckpointResultBean lastFailedSubChkPoint = this.getLastFailedCheckpointResultBean(lastFailedChkPoint.getSubCheckPoints());
                    if (lastFailedSubChkPoint != null && StringUtil.isNotBlank((String)lastFailedSubChkPoint.getScreenshot())) {
                        lastFailedChkPoint.setScreenshot(lastFailedSubChkPoint.getScreenshot());
                    } else {
                        stb.takeScreenShot();
                        lastFailedChkPoint.setScreenshot(stb.getLastCapturedScreenShot());
                    }
                }
            } else if (StringUtil.isNotBlank((String)failiremsg)) {
                this.logger.error((Object)tr.getThrowable());
                stb.takeScreenShot();
                CheckpointResultBean stepResultBean = new CheckpointResultBean();
                stepResultBean.setMessage(failiremsg);
                stepResultBean.setType(MessageTypes.Fail);
                stepResultBean.setScreenshot(stb.getLastCapturedScreenShot());
                stb.getCheckPointResults().add(stepResultBean);
            }
        }
    }

    protected void setFailure(ITestResult tr, ITestContext context) {
        if (ConfigurationManager.getBundle().getInt("testng.version", 6) > 5) {
            if (context.getPassedTests() != null) {
                if (context.getPassedTests().getResults(tr.getMethod()).size() > 1) {
                    context.getPassedTests().removeResult(tr);
                } else {
                    context.getPassedTests().removeResult(tr.getMethod());
                }
            }
            tr.setStatus(2);
            if (context.getFailedTests() != null) {
                context.getFailedTests().addResult(tr, tr.getMethod());
            }
        } else {
            tr.setStatus(2);
        }
    }

    protected void setSkip(ITestResult tr, ITestContext context) {
        if (ConfigurationManager.getBundle().getInt("testng.version", 6) > 5) {
            if (context.getFailedTests() != null) {
                if (context.getFailedTests().getResults(tr.getMethod()) != null && context.getFailedTests().getResults(tr.getMethod()).size() > 1) {
                    context.getFailedTests().getResults(tr.getMethod()).remove(tr);
                } else {
                    context.getFailedTests().removeResult(tr.getMethod());
                }
            }
            tr.setStatus(3);
            if (context.getSkippedTests() != null) {
                context.getSkippedTests().addResult(tr, tr.getMethod());
            }
        } else {
            tr.setStatus(3);
        }
    }

    private void generateTestFailedXML(ISuite suite) throws IOException {
        Map suiteResults = suite.getResults();
        XmlSuite xmlSuite = null;
        for (Map.Entry suiteResult : suiteResults.entrySet()) {
            IResultMap failedTests = ((ISuiteResult)suiteResult.getValue()).getTestContext().getFailedTests();
            IResultMap skippedTests = ((ISuiteResult)suiteResult.getValue()).getTestContext().getSkippedTests();
            HashSet failedOrSkipppedMethods = new HashSet();
            failedOrSkipppedMethods.addAll(failedTests.getAllMethods());
            failedOrSkipppedMethods.addAll(skippedTests.getAllMethods());
            if (failedOrSkipppedMethods.isEmpty() || !Scenario.class.isAssignableFrom(((ITestNGMethod)failedOrSkipppedMethods.iterator().next()).getRealClass())) continue;
            if (xmlSuite == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(suite.getName());
                xmlSuite.setParallel(suite.getParallel());
                xmlSuite.setThreadCount(suite.getXmlSuite().getThreadCount());
                xmlSuite.setListeners(suite.getXmlSuite().getListeners());
                xmlSuite.setParameters(suite.getXmlSuite().getParameters());
            }
            XmlTest test = new XmlTest(xmlSuite);
            test.setName(((ISuiteResult)suiteResult.getValue()).getTestContext().getName());
            test.setPreserveOrder("true");
            test.setParameters(((ISuiteResult)suiteResult.getValue()).getTestContext().getCurrentXmlTest().getTestParameters());
            XmlMethodSelectors methodSelectors = new XmlMethodSelectors();
            XmlMethodSelector methodSelector = new XmlMethodSelector();
            methodSelectors.setMethodSelector(methodSelector);
            XmlScript xmlScript = new XmlScript();
            xmlScript.setLanguage("beanshell");
            String scriptDataPart = "";
            for (ITestNGMethod testMethod : failedOrSkipppedMethods) {
                if (!Scenario.class.isAssignableFrom(testMethod.getRealClass())) continue;
                if (StringUtil.isNotEmpty((String)scriptDataPart)) {
                    scriptDataPart = String.valueOf(scriptDataPart) + "||";
                }
                if (!(testMethod.getInstance() instanceof Scenario)) continue;
                Scenario scenario = (Scenario)testMethod.getInstance();
                scriptDataPart = String.valueOf(scriptDataPart) + String.format("testngMethod.getMethodName().equalsIgnoreCase(\"%s\")", scenario.getTestName());
            }
            xmlScript.setScript(scriptDataPart);
            methodSelector.setScript(xmlScript);
            ArrayList<XmlMethodSelector> selectors = new ArrayList<XmlMethodSelector>();
            selectors.add(methodSelector);
            XmlClass testClass = null;
            ArrayList<XmlClass> classes = new ArrayList<XmlClass>();
            ArrayList methodsToRun = new ArrayList();
            testClass = new XmlClass();
            testClass.setName(BDDTestFactory.class.getName());
            testClass.setIncludedMethods(methodsToRun);
            classes.add(testClass);
            test.setMethodSelectors(selectors);
            test.setXmlClasses(classes);
        }
        if (xmlSuite != null) {
            File file = new File(String.valueOf(suite.getOutputDirectory().replace(suite.getName(), "")) + "testng-failed-qas.xml");
            FileWriter writer = new FileWriter(file);
            writer.write(xmlSuite.toXml());
            writer.close();
        }
    }

    private String getFailureMessage(Throwable t) {
        if (t == null) {
            return "";
        }
        String msg = t.getMessage();
        if (StringUtil.isNotBlank((String)msg)) {
            return msg;
        }
        return t.toString();
    }
}

