/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client.csv;

import com.qmetry.qaf.automation.step.client.AbstractScenarioFileParser;
import com.qmetry.qaf.automation.testng.DataProviderException;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KwdFileParser
extends AbstractScenarioFileParser {
    @Override
    protected Collection<Object[]> parseFile(String scenarioFile) {
        return this.getCSVData(scenarioFile, '|');
    }

    public List<Object[]> getCSVData(String strFile, char separatorChar) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        BufferedReader br = null;
        try {
            try {
                this.logger.info((Object)("loading  keywords/scenarios from file: " + strFile));
                File csvFile = new File(strFile);
                br = new BufferedReader(new FileReader(csvFile));
                String strLine = "";
                int lineNo = 0;
                while ((strLine = br.readLine()) != null) {
                    ++lineNo;
                    if ("".equalsIgnoreCase(strLine.trim()) || "#!".contains("" + strLine.trim().charAt(0))) continue;
                    Object[] cols = new Object[]{"", "", "", lineNo};
                    Object[] csvcols = StringUtil.parseCSV(strLine, separatorChar);
                    System.arraycopy(csvcols, 0, cols, 0, csvcols.length);
                    rows.add(cols);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception while reading csv file: " + strFile + e));
                throw new DataProviderException("Error while fetching data from " + strFile, e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rows;
    }
}

