/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.google.gson.Gson;
import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.step.QAFTestStepListener;
import com.qmetry.qaf.automation.step.StepExecutionTracker;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.text.BDDDefinitionHelper;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

class TestStepListener
implements QAFTestStepListener {
    private static final Log logger = LogFactoryImpl.getLog(TestStepListener.class);
    private ArrayList<CheckpointResultBean> allResults;
    private ArrayList<LoggingBean> allCommands;
    private boolean ignoreDefaultListener = false;

    @Override
    public void beforExecute(StepExecutionTracker stepExecutionTracker) {
        Map<String, Object> metadata = stepExecutionTracker.getStep().getMetaData();
        if (metadata != null && metadata.containsKey("qafstep-transaction")) {
            this.processTimeTracking(stepExecutionTracker);
        }
        if (!this.ignoreDefaultListener) {
            logger.info((Object)("Invoking " + this.getStepInfo(stepExecutionTracker.getStep())));
            QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
            this.allResults = new ArrayList<CheckpointResultBean>(stb.getCheckPointResults());
            this.allCommands = new ArrayList<LoggingBean>(stb.getLog());
            stb.getCheckPointResults().clear();
            stb.getLog().clear();
        }
    }

    @Override
    public void onFailure(StepExecutionTracker stepExecutionTracker) {
        if (!this.ignoreDefaultListener) {
            logger.error((Object)("Failure " + this.getStepInfo(stepExecutionTracker.getStep())), stepExecutionTracker.getException());
        }
    }

    @Override
    public void afterExecute(StepExecutionTracker stepExecutionTracker) {
        if (!this.ignoreDefaultListener) {
            this.afterStep(stepExecutionTracker);
            logger.info((Object)("Completed " + this.getStepInfo(stepExecutionTracker.getStep())));
        }
    }

    private void afterStep(StepExecutionTracker stepExecutionTracker) {
        Long duration = stepExecutionTracker.getEndTime() - stepExecutionTracker.getStartTime();
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        if (StringUtil.isNotBlank((String)stepExecutionTracker.getVerificationError())) {
            stb.addVerificationError(stepExecutionTracker.getVerificationError());
        }
        Boolean success = stepExecutionTracker.isSuccess();
        if (stepExecutionTracker.hasException()) {
            CheckpointResultBean failureCheckpoint = new CheckpointResultBean();
            failureCheckpoint.setMessage(stepExecutionTracker.getException().getMessage());
            failureCheckpoint.setType(MessageTypes.Fail);
            stb.getCheckPointResults().add(failureCheckpoint);
        }
        MessageTypes type = this.getStepMessageType(stb.getCheckPointResults());
        if (success == null) {
            success = !stepExecutionTracker.hasException() && !type.isFailure();
            stepExecutionTracker.setSuccess(success);
        }
        LoggingBean stepLogBean = new LoggingBean(stepExecutionTracker.getStep().getName(), new String[]{Arrays.toString(stepExecutionTracker.getStep().getActualArgs())}, success != false ? "success" : "fail");
        stepLogBean.setSubLogs(new ArrayList<LoggingBean>(stb.getLog()));
        CheckpointResultBean stepResultBean = new CheckpointResultBean();
        stepResultBean.setMessage(this.processArgs(stepExecutionTracker.getStep().getDescription(), stepExecutionTracker.getStep().getActualArgs()));
        stepResultBean.setSubCheckPoints(new ArrayList<CheckpointResultBean>(stb.getCheckPointResults()));
        stepResultBean.setDuration(((Number)duration).intValue());
        stepResultBean.setThreshold(stepExecutionTracker.getStep().getThreshold());
        stepResultBean.setType(type);
        this.allResults.add(stepResultBean);
        stb.getCheckPointResults().clear();
        stb.getCheckPointResults().addAll(this.allResults);
        this.allCommands.add(stepLogBean);
        stb.getLog().clear();
        stb.getLog().addAll(this.allCommands);
    }

    private String getStepInfo(TestStep step) {
        return "Teststep: " + step.getDescription() + (step.getActualArgs() != null && step.getActualArgs().length > 0 ? " with arguments: " + Arrays.toString(step.getActualArgs()) : "");
    }

    private MessageTypes getStepMessageType(List<CheckpointResultBean> subSteps) {
        MessageTypes type = MessageTypes.TestStepPass;
        for (CheckpointResultBean subStep : subSteps) {
            if (StringMatcher.containsIgnoringCase("fail").match(subStep.getType())) {
                return MessageTypes.TestStepFail;
            }
            if (!StringMatcher.containsIgnoringCase("warn").match(subStep.getType())) continue;
            type = MessageTypes.Warn;
        }
        return type;
    }

    private void processTimeTracking(StepExecutionTracker stepExecutionTracker) {
        QAFTestBase testBase = (QAFTestBase)TestBaseProvider.instance().get();
        PropertyUtil context = testBase.getContext();
        if (context.containsKey("start.transation.tracker")) {
            StepExecutionTracker starStepExecutionTracker = (StepExecutionTracker)context.getObject("start.transation.tracker");
            context.clearProperty("start.transation.tracker");
            this.ignoreDefaultListener = true;
            int stIndex = this.getCheckPointIndex(testBase.getCheckPointResults(), this.processArgs(starStepExecutionTracker.getStep().getDescription(), starStepExecutionTracker.getStep().getActualArgs()));
            ArrayList<CheckpointResultBean> allcheckPoints = new ArrayList<CheckpointResultBean>(testBase.getCheckPointResults().subList(0, stIndex));
            ArrayList<CheckpointResultBean> subcheckPoints = new ArrayList<CheckpointResultBean>(testBase.getCheckPointResults().subList(stIndex + 1, testBase.getCheckPointResults().size()));
            int duration = 0;
            MessageTypes type = this.getStepMessageType(subcheckPoints);
            for (CheckpointResultBean checkpoint : subcheckPoints) {
                duration += checkpoint.getDuration();
            }
            CheckpointResultBean stepResultBean = new CheckpointResultBean();
            stepResultBean.setMessage((String)starStepExecutionTracker.getStep().getActualArgs()[0]);
            String threshold = starStepExecutionTracker.getStep().getActualArgs()[1].toString();
            stepResultBean.setThreshold(StringUtil.isBlank((String)threshold) ? 0 : Integer.parseInt(threshold));
            stepResultBean.setSubCheckPoints(subcheckPoints);
            stepResultBean.setDuration(duration);
            stepResultBean.setType(type);
            allcheckPoints.add(stepResultBean);
            testBase.getCheckPointResults().clear();
            testBase.getCheckPointResults().addAll(allcheckPoints);
            int commandIndex = this.getLogginIndex(testBase.getLog(), starStepExecutionTracker.getStep().getName());
            ArrayList<LoggingBean> allCommands = new ArrayList<LoggingBean>(testBase.getLog().subList(0, commandIndex));
            ArrayList<LoggingBean> subCommands = new ArrayList<LoggingBean>(testBase.getLog().subList(commandIndex + 1, testBase.getLog().size()));
            LoggingBean commandLogBean = new LoggingBean(starStepExecutionTracker.getStep().getName(), new String[]{Arrays.toString(starStepExecutionTracker.getStep().getActualArgs())}, type.isFailure() ? "fail" : "success");
            commandLogBean.setSubLogs(new ArrayList<LoggingBean>(subCommands));
            duration = 0;
            for (LoggingBean subCommand : subCommands) {
                duration += subCommand.getDuration();
            }
            commandLogBean.setDuration(duration);
            allCommands.add(commandLogBean);
            testBase.getLog().clear();
            testBase.getLog().addAll(allCommands);
        } else {
            context.addProperty("start.transation.tracker", stepExecutionTracker);
        }
    }

    private int getLogginIndex(List<LoggingBean> logs, String name) {
        int i = logs.size() - 1;
        while (i >= 0) {
            if (name.equalsIgnoreCase(logs.get(i).getCommandName())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private int getCheckPointIndex(List<CheckpointResultBean> logs, String name) {
        int i = logs.size() - 1;
        while (i >= 0) {
            if (name.equalsIgnoreCase(logs.get(i).getMessage())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private String processArgs(String description, Object ... actualArgs) {
        if (actualArgs == null || actualArgs.length <= 0) {
            return description;
        }
        List<String> args = BDDDefinitionHelper.getArgNames(description);
        if (args.isEmpty() || args.size() != actualArgs.length) {
            return description;
        }
        try {
            int i = 0;
            while (i < actualArgs.length) {
                description = actualArgs[i] instanceof String ? (description.indexOf("$") >= 0 ? StringUtil.replace((String)description, (String)("$" + args.get(i)), (String)this.getParam((String)actualArgs[i]), (int)1) : StringUtil.replace((String)description, (String)args.get(i), (String)("'" + this.getParam((String)actualArgs[i]) + "'"), (int)1)) : StringUtil.replace((String)description, (String)args.get(i), (String)("'" + String.valueOf(actualArgs[i]) + "'"), (int)1);
                ++i;
            }
        }
        catch (Exception exception) {}
        return description;
    }

    private String getParam(String text) {
        String result = ConfigurationManager.getBundle().getSubstitutor().replace(text);
        BDDDefinitionHelper.ParamType ptype = BDDDefinitionHelper.ParamType.getType(result);
        if (ptype.equals((Object)BDDDefinitionHelper.ParamType.MAP)) {
            Map kv = (Map)new Gson().fromJson(result, Map.class);
            if (kv.containsKey("desc")) {
                result = String.valueOf(kv.get("desc"));
            } else if (kv.containsKey("description")) {
                result = String.valueOf(kv.get("description"));
            }
        }
        return result;
    }
}

