/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.report;

import com.qmetry.qaf.automation.integration.TestCaseRunResult;

public class StatusCounter {
    private String name;
    private int pass;
    private int fail;
    private int skip;
    private String file;

    protected StatusCounter(String name) {
        this.name = name;
        this.file = name;
    }

    public static StatusCounter of(String name) {
        return new StatusCounter(name);
    }

    public StatusCounter withFile(String file) {
        this.file = file;
        return this;
    }

    public void add(TestCaseRunResult.Status s) {
        if (s.equals((Object)TestCaseRunResult.Status.PASS)) {
            ++this.pass;
        }
        if (s.equals((Object)TestCaseRunResult.Status.FAIL)) {
            ++this.fail;
        }
        if (s.equals((Object)TestCaseRunResult.Status.SKIPPED)) {
            ++this.skip;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPass() {
        return this.pass;
    }

    public int getFail() {
        return this.fail;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getTotal() {
        return this.pass + this.fail + this.skip;
    }

    public String getStatus() {
        return this.getTotal() == this.pass ? "pass" : "fail";
    }

    public int getPassRate() {
        return this.pass > 0 ? this.pass * 100 / (this.pass + this.fail + this.skip) : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.file.equalsIgnoreCase(obj.toString());
    }

    public String toString() {
        return this.file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

