/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.report;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.integration.TestCaseResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class SourceGenerator
implements TestCaseResultUpdator {
    public static final String REPORT_DIR = ConfigurationManager.getBundle().getString("sourcegenerator.dest", "auto_generated/java");
    private static String LAST_TEST_NAME;
    private static int testCnt;
    private static int featureCnt;
    private static int scenarioCnt;

    static {
        testCnt = 0;
        featureCnt = 0;
        scenarioCnt = 0;
    }

    @Override
    public String getToolName() {
        return "QAF Source Generator";
    }

    @Override
    public boolean updateResult(TestCaseRunResult tr) {
        if (testCnt == 0) {
            FileUtil.deleteQuietly((File)new File(REPORT_DIR));
        }
        String storyfileName = tr.getClassName();
        ++testCnt;
        try {
            Map testData;
            File feature = new File(String.valueOf(REPORT_DIR) + "/" + storyfileName + ".feature");
            String featureName = tr.getMetaData().getOrDefault("story", tr.getMetaData().getOrDefault("Feature", storyfileName)).toString();
            if (!feature.exists()) {
                String header = "Feature: " + featureName;
                FileUtil.write((File)feature, (CharSequence)header, (Charset)StandardCharsets.UTF_8, (boolean)true);
                ++featureCnt;
            }
            StringBuffer scenario = new StringBuffer();
            Map map = testData = tr.getTestData() == null || tr.getTestData().isEmpty() ? null : (Map)tr.getTestData().iterator().next();
            if (testData != null) {
                testData.remove("__index");
                String testName = StringUtil.toCamelCaseIdentifier(tr.getName());
                if (!testName.equalsIgnoreCase(LAST_TEST_NAME)) {
                    LAST_TEST_NAME = testName;
                    this.addSecanrio(scenario, tr);
                    this.addExampleHeader(scenario, testData);
                }
                scenario.append("\n  | ");
                for (Object value : testData.values()) {
                    scenario.append(" " + value + " |");
                }
            } else {
                this.addSecanrio(scenario, tr);
            }
            FileUtil.write((File)feature, (CharSequence)scenario, (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean allowParallel() {
        return false;
    }

    @Override
    public void beforeShutDown() {
        System.out.printf("\nGenerated %d scenarios and %d feature files from %d TestCases under %s.\n", scenarioCnt, featureCnt, testCnt, REPORT_DIR);
    }

    private void addExampleHeader(StringBuffer data, Map<String, Object> testData) {
        data.append("\nExamples:\n  |");
        for (String value : testData.keySet()) {
            data.append(" " + value + " |");
        }
    }

    private void addMetadata(StringBuffer data, TestCaseRunResult tr) {
        data.append("\n\n");
        ArrayList<String> exclude = new ArrayList<String>(Arrays.asList("sign", "name", "lineNo", "Feature", "reference"));
        QAFDataProvider.params[] paramsArray = QAFDataProvider.params.values();
        int n = paramsArray.length;
        int n2 = 0;
        while (n2 < n) {
            QAFDataProvider.params param = paramsArray[n2];
            exclude.add(param.name());
            ++n2;
        }
        for (Map.Entry<String, Object> kv : tr.getMetaData().entrySet()) {
            if (exclude.stream().anyMatch(kv.getKey()::equalsIgnoreCase) || kv.getValue() == null || !StringUtil.isNotBlank((String)kv.getValue().toString())) continue;
            if (kv.getKey().equalsIgnoreCase("groups")) {
                Object groups = kv.getValue();
                String[] allgroups = groups instanceof Collection ? ((Collection)groups).toArray(new String[0]) : (String[])groups;
                String[] stringArray = allgroups;
                int n3 = allgroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    String group = stringArray[n4];
                    data.append("\n@" + group);
                    ++n4;
                }
                continue;
            }
            data.append("\n@" + kv.getKey() + ": " + JSONUtil.toString(kv.getValue()));
        }
    }

    private void addSecanrio(StringBuffer data, TestCaseRunResult tr) {
        ++scenarioCnt;
        this.addMetadata(data, tr);
        data.append("\nScenario: ").append(tr.getName());
        if (tr.getSteps() == null || tr.getSteps().isEmpty()) {
            for (CheckpointResultBean chkpoint : tr.getCheckPoints()) {
                data.append("\n    ").append(chkpoint.getMessage());
            }
        } else {
            for (String step : tr.getSteps()) {
                data.append("\n    ").append(step);
            }
        }
    }
}

