/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.data.MetaData;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.TestNGScenario;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.Test;
import org.testng.xml.XmlTest;

public class MetaDataScanner {
    private static final Log logger = LogFactoryImpl.getLog(MetaDataScanner.class);

    public static Map<String, Object> getMetadata(AccessibleObject methodOrFileld, boolean excludeTest) {
        TreeMap<String, Object> metadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        metadata.putAll(MetaDataScanner.metadataFromClass(methodOrFileld));
        try {
            Annotation[] allAnnotations;
            Annotation[] annotationArray = allAnnotations = methodOrFileld.getAnnotations();
            int n = allAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (!excludeTest || !(annotation instanceof Test)) {
                    Method[] annotationMethods;
                    Method[] methodArray = annotationMethods = annotation.annotationType().getDeclaredMethods();
                    int n3 = annotationMethods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method annotationMethod = methodArray[n4];
                        Object objVal = annotationMethod.invoke((Object)annotation, new Object[0]);
                        if (annotation instanceof MetaData) {
                            Map map = (Map)new Gson().fromJson((String)objVal, Map.class);
                            metadata.putAll(map);
                        } else {
                            metadata.put(annotationMethod.getName(), objVal);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return metadata;
    }

    public static Map<String, Object> metadataFromClass(AccessibleObject methodOrFileld) {
        try {
            MetaData metaData = ClassUtil.getAnnotation(((Method)methodOrFileld).getDeclaringClass(), MetaData.class);
            if (metaData != null) {
                return JSONUtil.toObject(metaData.value(), Map.class);
            }
        }
        catch (Exception e) {
            logger.trace((Object)e);
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> getMetadata(AccessibleObject methodOrFileld) {
        return MetaDataScanner.getMetadata(methodOrFileld, false);
    }

    public static String getParameter(XmlTest xmlTest, String parameter) {
        String paramValue = "";
        boolean overrideUsingSystemProp = System.getProperties().containsKey(parameter);
        Map context = xmlTest.getAllParameters();
        context.keySet().removeAll(System.getProperties().keySet());
        if (overrideUsingSystemProp) {
            paramValue = System.getProperty(parameter);
        } else if (context.containsKey(parameter)) {
            paramValue = (String)context.get(parameter);
        } else if (ConfigurationManager.getBundle().containsKey(parameter)) {
            try {
                paramValue = (String)ConfigurationManager.getBundle().configurationAt(parameter).getRoot().getValue();
            }
            catch (Exception exception) {
                paramValue = ConfigurationManager.getBundle().getString(parameter, "");
            }
        }
        paramValue = StrSubstitutor.replace((Object)paramValue, (Map)context);
        paramValue = ConfigurationManager.getBundle().getSubstitutor().replace(paramValue);
        return paramValue;
    }

    public static String getParameter(ITestContext context, String parameter) {
        return MetaDataScanner.getParameter(context.getCurrentXmlTest(), parameter);
    }

    public static String getParameter(ITestNGMethod method, String parameter) {
        if (method != null && method.getXmlTest() != null) {
            return MetaDataScanner.getParameter(method.getXmlTest(), parameter);
        }
        return ConfigurationManager.getBundle().getString(parameter);
    }

    public static boolean hasDP(Map<String, Object> metadata) {
        if (metadata == null) {
            return false;
        }
        TreeMap<String, Object> kv = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        kv.putAll(metadata);
        QAFDataProvider.params[] paramsArray = QAFDataProvider.params.values();
        int n = paramsArray.length;
        int n2 = 0;
        while (n2 < n) {
            QAFDataProvider.params key = paramsArray[n2];
            if (kv.containsKey(key.name())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void formatMetaData(Map<String, Object> metadata) {
        Configuration formats = ConfigurationManager.getBundle().subset(ApplicationProperties.METADATA_FORMTTOR_PREFIX.key);
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String format = formats.getString(entry.getKey(), "");
            Object value = entry.getValue();
            if (value instanceof List) {
                List lVal = (List)value;
                int i = 0;
                while (i < lVal.size()) {
                    if (StringUtil.isNotBlank((String)format) && !MetaDataScanner.matches(format, lVal.get(i).toString())) {
                        try {
                            String formattedVal = MessageFormat.format(format, lVal.get(i));
                            lVal.set(i, formattedVal);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unable to format metadata [" + entry.getKey() + "] using format [" + format + "]"), (Throwable)e);
                        }
                    }
                    ++i;
                }
                continue;
            }
            if (!StringUtil.isNotBlank((String)format) || MetaDataScanner.matches(format, value.toString())) continue;
            try {
                String formattedVal = MessageFormat.format(format, value);
                entry.setValue(formattedVal);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to format metadata [" + entry.getKey() + "] using format [" + format + "]"), (Throwable)e);
            }
        }
    }

    public static String applyMetaRule(Map<String, Object> metadata) {
        StringBuffer result = new StringBuffer();
        List rules = (List)new Gson().fromJson(ApplicationProperties.METADATA_RULES.getStringVal("[]"), new TypeToken<ArrayList<MetaDataRule>>(){}.getType());
        for (MetaDataRule rule : rules) {
            result.append(rule.apply(metadata));
        }
        return result.toString();
    }

    public static boolean applyMetafilter(Map<String, Object> metadata) {
        Object enabled = metadata.get("enabled");
        if (enabled != null && !"true".equalsIgnoreCase(enabled.toString())) {
            return false;
        }
        return MetaDataScanner.applyMetafilter(null, metadata);
    }

    public static boolean applyMetafilter(ITestNGMethod imethod) {
        Map<Object, Object> scenarioMetadata = new HashMap();
        if (imethod instanceof TestNGScenario) {
            TestNGScenario method = (TestNGScenario)imethod;
            scenarioMetadata = method.getMetaData();
        } else if (Scenario.class.isAssignableFrom(imethod.getRealClass())) {
            Scenario method = (Scenario)imethod.getInstance();
            scenarioMetadata = method.getMetadata();
        } else {
            scenarioMetadata = MetaDataScanner.getMetadata(imethod.getConstructorOrMethod().getMethod(), false);
        }
        return MetaDataScanner.applyMetafilter(imethod, scenarioMetadata);
    }

    private static boolean applyMetafilter(ITestNGMethod imethod, Map<String, Object> scenarioMetadata) {
        String includeStr = MetaDataScanner.getParameter(imethod, "include");
        String excludeStr = MetaDataScanner.getParameter(imethod, "exclude");
        if (StringUtil.isBlank((String)includeStr) && StringUtil.isBlank((String)excludeStr)) {
            return true;
        }
        Gson gson = new GsonBuilder().create();
        Map includeMeta = (Map)gson.fromJson(includeStr, Map.class);
        Map excludeMeta = (Map)gson.fromJson(excludeStr, Map.class);
        return MetaDataScanner.includeMethod(scenarioMetadata, includeMeta, excludeMeta);
    }

    public static boolean includeMethod(Map<String, Object> scenarioMetadata, Map<String, Object> includeMeta, Map<String, Object> excludeMeta) {
        boolean bexclude;
        boolean binclude = includeMeta == null || includeMeta.isEmpty() || MetaDataScanner.hasMetaValue(includeMeta, scenarioMetadata, true);
        boolean bl = bexclude = excludeMeta != null && !excludeMeta.isEmpty() && MetaDataScanner.hasMetaValue(excludeMeta, scenarioMetadata, false);
        return binclude && !bexclude;
    }

    private static boolean hasMetaValue(Map<String, Object> metaFilter, Map<String, Object> metadata, boolean isInclude) {
        Set<String> filterKeys = metaFilter.keySet();
        for (String metaKey : filterKeys) {
            Object metaVal = metadata.get(metaKey);
            Set<Object> scMetaValues = MetaDataScanner.getMetaValues(metaVal);
            Object metaValuesObjForKey = metaFilter.get(metaKey);
            Set<Object> metaValuesForKey = MetaDataScanner.getMetaValues(metaValuesObjForKey);
            if (metaValuesForKey.isEmpty()) continue;
            scMetaValues.retainAll(metaValuesForKey);
            if (!(isInclude ? scMetaValues.isEmpty() : !scMetaValues.isEmpty())) continue;
            return !isInclude;
        }
        return isInclude;
    }

    private static Set<Object> getMetaValues(Object metaVal) {
        if (metaVal == null) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(metaVal.getClass())) {
            return new HashSet<Object>((List)metaVal);
        }
        if (metaVal.getClass().isArray()) {
            Object[] vals = (Object[])metaVal;
            return new HashSet<Object>(Arrays.asList(vals));
        }
        return new HashSet<Object>(Arrays.asList(metaVal));
    }

    private static boolean matches(String formatStr, String s) {
        MessageFormat messageFormat = new MessageFormat(formatStr);
        try {
            return messageFormat.parse(s).length > 0;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private static class MetaDataRule {
        private String key;
        private MetaDataRule depends;
        private List<Object> values;
        private Boolean required;

        private MetaDataRule() {
        }

        public String apply(Map<String, Object> metadata) {
            boolean isApplicable = this.isApplicable(metadata);
            if (metadata.containsKey(this.key)) {
                if (!isApplicable) {
                    return "\nFound not aplicable Meta data [" + this + "]";
                }
                List<Object> declariedValues = this.getValues(this.key, metadata);
                for (Object value : declariedValues) {
                    boolean matched = false;
                    for (Object allowedValue : this.values) {
                        boolean bl = matched = matched || value.toString().matches(allowedValue.toString());
                    }
                    if (matched) continue;
                    return "\nValue mismatch for Meta data [" + this + "]";
                }
            } else if (this.required != null && this.required.booleanValue() && isApplicable) {
                return "\nMissing required meta data [" + this + "]";
            }
            return "";
        }

        private boolean isApplicable(Map<String, Object> metadata) {
            if (this.depends == null) {
                return true;
            }
            this.depends.required = true;
            return StringUtil.isBlank((String)this.depends.apply(metadata));
        }

        private List<Object> getValues(String key, Map<String, Object> metadata) {
            Object val = metadata.get(key);
            if (val instanceof List) {
                return (List)val;
            }
            return Arrays.asList(val);
        }

        public String toString() {
            return new Gson().toJson((Object)this);
        }
    }
}

