/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.data;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.data.BaseDataBean;
import com.qmetry.qaf.automation.data.ElementInteractor;
import com.qmetry.qaf.automation.ui.annotations.UiElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.json.JSONObject;

public class BaseFormDataBean
extends BaseDataBean {
    private Field[] allFields;
    protected final ElementInteractor interactor = new ElementInteractor();

    public void fillUiElements(String ... fieldLocs) {
        List<String> includeLst = null;
        if (fieldLocs != null && fieldLocs.length > 0) {
            includeLst = Arrays.asList(fieldLocs);
        }
        Field[] fieldArray = this.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(UiElement.class) && (includeLst == null || includeLst.contains(field.getName()) || includeLst.contains(field.getAnnotation(UiElement.class).fieldLoc()))) {
                this.fillUiData(field);
            }
            ++n2;
        }
    }

    public void fillUiRequiredElements() {
        Field[] fieldArray = this.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(UiElement.class) && field.getAnnotation(UiElement.class).required()) {
                this.fillUiData(field);
            }
            ++n2;
        }
    }

    public final void fetchUiElements(String ... fieldLocs) {
        Field[] flds = this.getFields();
        List<String> includeLst = null;
        if (fieldLocs != null && fieldLocs.length > 0) {
            includeLst = Arrays.asList(fieldLocs);
        }
        Field[] fieldArray = flds;
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            fld.setAccessible(true);
            if (!Modifier.isFinal(fld.getModifiers()) && fld.isAnnotationPresent(UiElement.class)) {
                UiElement map = fld.getAnnotation(UiElement.class);
                if (includeLst == null || includeLst.contains(fld.getName()) || includeLst.contains(map.fieldLoc())) {
                    Object val = this.fetchUiData(fld);
                    this.setField(fld, String.valueOf(val));
                }
            }
            ++n2;
        }
    }

    public final boolean verifyUiElements(String ... fieldmapnames) {
        Field[] flds = this.getClass().getDeclaredFields();
        List<String> includeLst = null;
        boolean outcome = true;
        if (fieldmapnames != null && fieldmapnames.length > 0) {
            includeLst = Arrays.asList(fieldmapnames);
        }
        Field[] fieldArray = flds;
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            fld.setAccessible(true);
            if (fld.isAnnotationPresent(UiElement.class)) {
                String mapName;
                UiElement map = fld.getAnnotation(UiElement.class);
                String string = mapName = StringUtil.isNotBlank((String)map.viewLoc()) ? map.viewLoc() : fld.getName();
                if (includeLst == null || includeLst.contains(mapName)) {
                    outcome = outcome && this.verifyUiData(fld);
                }
            }
            ++n2;
        }
        return outcome;
    }

    public final boolean verifyUiVaules(String ... fieldmapnames) {
        Field[] flds = this.getClass().getDeclaredFields();
        List<String> includeLst = null;
        boolean outcome = true;
        if (fieldmapnames != null && fieldmapnames.length > 0) {
            includeLst = Arrays.asList(fieldmapnames);
        }
        Field[] fieldArray = flds;
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            fld.setAccessible(true);
            if (fld.isAnnotationPresent(UiElement.class)) {
                String mapName;
                UiElement map = fld.getAnnotation(UiElement.class);
                String string = mapName = StringUtil.isNotBlank((String)map.viewLoc()) ? map.viewLoc() : fld.getName();
                if (includeLst == null || includeLst.contains(mapName)) {
                    outcome = outcome && this.verifyUiData(fld);
                }
            }
            ++n2;
        }
        return outcome;
    }

    public final <T> boolean setBeanData(String propNameOrMapping, T data) {
        Field fld = this.getField(propNameOrMapping);
        try {
            this.setField(fld, String.valueOf(data));
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while geting field " + fld.getName() + "  data"), (Throwable)e);
            return false;
        }
    }

    public final <T> T getBeanData(String propNameOrMapping) {
        Field fld = this.getField(propNameOrMapping);
        try {
            fld.setAccessible(true);
            return (T)fld.get(this);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while geting field " + fld.getName() + "  data"), (Throwable)e);
            return null;
        }
    }

    protected Field getField(String nameOrLoc) {
        Field[] flds;
        Field[] fieldArray = flds = this.getFields();
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            if (fld.getName().equalsIgnoreCase(nameOrLoc)) {
                return fld;
            }
            UiElement element = fld.getAnnotation(UiElement.class);
            if (element != null && (element.fieldLoc().equalsIgnoreCase(nameOrLoc) || element.viewLoc().equalsIgnoreCase(nameOrLoc))) {
                return fld;
            }
            ++n2;
        }
        throw new RuntimeException("No property found to map with " + nameOrLoc);
    }

    protected String getMappedFieldLoc(Field fld) {
        if (fld.isAnnotationPresent(UiElement.class)) {
            UiElement map = fld.getAnnotation(UiElement.class);
            return map.fieldLoc();
        }
        return "";
    }

    protected String getMappedViewLoc(Field fld) {
        if (fld.isAnnotationPresent(UiElement.class)) {
            UiElement map = fld.getAnnotation(UiElement.class);
            return map.viewLoc();
        }
        return "";
    }

    protected boolean checkParent(String parent, String depVal) {
        String parentval = String.valueOf((char[])this.getBeanData(parent));
        return depVal.equalsIgnoreCase(parentval) || BaseFormDataBean.isExpr(depVal) && this.resolveExpr(depVal) != false;
    }

    @Override
    protected Field[] getFields() {
        if (this.allFields == null) {
            this.allFields = ClassUtil.getAllFields(this.getClass(), BaseFormDataBean.class);
            Arrays.sort(this.allFields, new FieldsComparator());
        }
        return this.allFields;
    }

    private static boolean isExpr(String str) {
        Pattern p = Pattern.compile("\\$\\{(\\w+)\\}", 8);
        Matcher m = p.matcher(str);
        return m.find();
    }

    private Boolean resolveExpr(String strExpr) {
        Pattern p = Pattern.compile("\\$\\{(\\w+)\\}", 8);
        Matcher m = p.matcher(strExpr);
        this.logger.info((Object)("Evaluating expr: " + strExpr));
        while (m.find()) {
            String param = m.group(1);
            String paramVal = (String)this.getBeanData(m.group(1));
            this.logger.info((Object)("parameter " + param + ": " + paramVal));
            strExpr = strExpr.replaceAll("\\$\\{" + param + "\\}", String.valueOf(paramVal));
        }
        try {
            return (Boolean)StringUtil.eval(strExpr, new JSONObject((Object)this).toMap());
        }
        catch (ScriptException e) {
            this.logger.error((Object)("Unable to evaluate dependency condition: " + strExpr), (Throwable)e);
            throw new AutomationError("Unable to evaluate dependency condition: " + strExpr, e);
        }
    }

    private Object fetchUiData(Field field) {
        try {
            Method m = this.getClass().getDeclaredMethod("fetch" + StringUtil.getTitleCase(field.getName()), new Class[0]);
            m.setAccessible(true);
            this.logger.debug((Object)("invoking custom fetch method for field " + field.getName()));
            return m.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            UiElement map = field.getAnnotation(UiElement.class);
            if (map == null) {
                return null;
            }
            UiElement.Type type = map.fieldType();
            String loc = map.fieldLoc();
            Class<? extends QAFExtendedWebElement> eleClass = map.elementClass();
            return this.interactor.fetchValue(loc, type, eleClass);
        }
    }

    private void fillUiData(Field fld) {
        UiElement params2 = fld.getAnnotation(UiElement.class);
        if (params2 == null || params2.readonly()) {
            return;
        }
        UiElement.Type type = params2.fieldType();
        String loc = params2.fieldLoc();
        String val = params2.defaultValue();
        String depends = params2.dependsOnField();
        String depVal = params2.dependingValue();
        Class<? extends QAFExtendedWebElement> eleClass = params2.elementClass();
        try {
            fld.setAccessible(true);
            Object o = fld.get(this);
            this.logger.debug((Object)("value " + o + " for" + fld.getName()));
            val = o == null ? null : String.valueOf(o);
        }
        catch (NullPointerException nullPointerException) {
            val = null;
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to get data from bean for " + fld.getName()), (Throwable)e);
        }
        if (val != null && (StringUtil.isBlank((String)depends) || StringUtil.isBlank((String)depVal) || this.checkParent(depends, depVal))) {
            try {
                Method m = ClassUtil.getMethod(this.getClass(), "fill" + StringUtil.getTitleCase(fld.getName()));
                m.setAccessible(true);
                this.logger.debug((Object)("invoking custom fill method for field " + fld.getName()));
                m.invoke((Object)this, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.interactor.fillValue(loc, val, type, eleClass);
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to invoke custom fill method for field " + fld.getName()), (Throwable)e);
                throw new AutomationError("Unable to invoke custom fill method for field " + fld.getName(), e);
            }
        }
    }

    private boolean verifyUiData(Field fld) {
        UiElement map = fld.getAnnotation(UiElement.class);
        UiElement.Type type = map.fieldType();
        String loc = map.fieldLoc();
        String depends = map.dependsOnField();
        String depVal = map.dependingValue();
        Class<? extends QAFExtendedWebElement> eleClass = map.elementClass();
        try {
            if (StringUtil.isBlank((String)depends) || this.checkParent(depends, depVal)) {
                return this.interactor.verifyValue(loc, String.valueOf((char[])this.getBeanData(loc)), type, eleClass);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    private class FieldsComparator
    implements Comparator<Field> {
        private FieldsComparator() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            return this.getOrder(o1) - this.getOrder(o2);
        }

        private int getOrder(Field f) {
            return f.isAnnotationPresent(UiElement.class) ? f.getAnnotation(UiElement.class).order() : Integer.MAX_VALUE;
        }
    }
}

