/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.CheckpointResultFormatter;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.Collection;

public class HtmlCheckpointResultFormatter
implements CheckpointResultFormatter {
    private static final String SEC_Header = "<div style=\"display:block;margin-left:10px;\">";
    private static final String SEC_Footer = "</div>";

    @Override
    public String getResults(Collection<CheckpointResultBean> bean) {
        StringBuilder sb = new StringBuilder(SEC_Header);
        for (CheckpointResultBean checkpointResultBean : bean) {
            String msg = checkpointResultBean.getMessage();
            if (StringUtil.isNotBlank((String)checkpointResultBean.getScreenshot())) {
                msg = String.valueOf(msg) + this.formatScreenshot(checkpointResultBean.getScreenshot());
            }
            sb.append(MessageTypes.valueOf(checkpointResultBean.getType()).formatMessage(msg));
            if (checkpointResultBean.getSubCheckPoints().isEmpty()) continue;
            sb.append(this.getResults(checkpointResultBean.getSubCheckPoints()));
        }
        sb.append(SEC_Footer);
        return sb.toString();
    }

    private String formatScreenshot(String sc) {
        return " <a href=\"" + sc + "\" target=\"_blank\">[View Screenshot]</a> ";
    }
}

