/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Base64;
import com.qcloud.iot_explorer.device.CA;
import com.qcloud.iot_explorer.utils.Asn1Object;
import com.qcloud.iot_explorer.utils.DerParser;
import com.qcloud.iot_explorer.utils.TXLog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Random;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;

public class AsymcSslUtils {
    public static final String TAG = "iot.AsymcSslUtils";
    private static String PASSWORD = String.valueOf(new Random(System.currentTimeMillis()).nextInt());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSocketFactoryByAssetsFile(Context context, String clientCrtFileName, String clientPriKeyFileName) {
        SSLSocketFactory factory = null;
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        InputStream clientInputStream = null;
        InputStream keyInputStream = null;
        try {
            clientInputStream = assetManager.open(clientCrtFileName);
            keyInputStream = assetManager.open(clientPriKeyFileName);
            factory = AsymcSslUtils.getSocketFactoryByStream(clientInputStream, keyInputStream);
        }
        catch (IOException e) {
            TXLog.e(TAG, "getSocketFactory failed, cannot open CRT Files.", e);
        }
        finally {
            if (clientInputStream != null) {
                try {
                    clientInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (keyInputStream != null) {
                try {
                    keyInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSocketFactoryByFile(String clientCrtFileName, String clientPriKeyFileName) {
        InputStream clientInputStream = null;
        InputStream keyInputStream = null;
        SSLSocketFactory factory = null;
        try {
            clientInputStream = new FileInputStream(new File(clientCrtFileName));
            keyInputStream = new FileInputStream(new File(clientPriKeyFileName));
            factory = AsymcSslUtils.getSocketFactoryByStream(clientInputStream, keyInputStream);
        }
        catch (IOException e) {
            TXLog.e(TAG, "getSocketFactory failed, cannot open CRT Files.", e);
        }
        finally {
            if (clientInputStream != null) {
                try {
                    clientInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (keyInputStream != null) {
                try {
                    keyInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return factory;
    }

    public static SSLSocketFactory getSocketFactoryByStream(InputStream clientInput, InputStream keyInput) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            TXLog.e(TAG, "getSocketFactory failed, create CertificateFactory error.", e);
        }
        PEMParser parser = null;
        X509Certificate caCert = null;
        X509Certificate clientCert = null;
        PrivateKey privateKey = null;
        ByteArrayInputStream caInput = new ByteArrayInputStream(CA.caCrt.getBytes(Charset.forName("UTF-8")));
        parser = new PEMParser((Reader)new InputStreamReader(caInput));
        Object object = null;
        try {
            object = parser.readObject();
        }
        catch (IOException e) {
            TXLog.e(TAG, "parse CA failed.", e);
            return null;
        }
        if (!(object instanceof X509CertificateHolder)) {
            TXLog.e(TAG, "CA file not X509CertificateHolder.");
            return null;
        }
        X509CertificateHolder certificateHolder = (X509CertificateHolder)object;
        try {
            ByteArrayInputStream caIn = new ByteArrayInputStream(certificateHolder.getEncoded());
            caCert = (X509Certificate)certFactory.generateCertificate(caIn);
            ((InputStream)caIn).close();
            parser.close();
        }
        catch (Exception e) {
            TXLog.e(TAG, "generate CA certtificate failed.", e);
            return null;
        }
        parser = new PEMParser((Reader)new InputStreamReader(clientInput));
        Object object2 = null;
        try {
            object2 = parser.readObject();
        }
        catch (IOException e) {
            TXLog.e(TAG, "parse Client CRT failed.", e);
            return null;
        }
        if (!(object2 instanceof X509CertificateHolder)) {
            TXLog.e(TAG, "Client CRT file not X509CertificateHolder.");
            return null;
        }
        X509CertificateHolder certificateHolder2 = (X509CertificateHolder)object2;
        try {
            ByteArrayInputStream clientIn = new ByteArrayInputStream(certificateHolder2.getEncoded());
            clientCert = (X509Certificate)certFactory.generateCertificate(clientIn);
            ((InputStream)clientIn).close();
            parser.close();
        }
        catch (Exception e) {
            TXLog.e(TAG, "generate Client certtificate failed.", e);
            return null;
        }
        try {
            privateKey = AsymcSslUtils.getPrivateKey(keyInput, null);
        }
        catch (Exception e) {
            TXLog.e(TAG, "generate PrivateKey failed.", e);
            return null;
        }
        try {
            KeyStore caKs = KeyStore.getInstance(KeyStore.getDefaultType());
            caKs.load(null, null);
            caKs.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(caKs);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            ks.setCertificateEntry("certificate", clientCert);
            ks.setKeyEntry("private-key", privateKey, PASSWORD.toCharArray(), new Certificate[]{clientCert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, PASSWORD.toCharArray());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            TXLog.e(TAG, "construct SSLSocketFactory failed.", e);
            return null;
        }
    }

    public static SSLSocketFactory getSocketFactory() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            TXLog.e(TAG, "getSocketFactory failed, create CertificateFactory error.", e);
        }
        PEMParser parser = null;
        X509Certificate caCert = null;
        ByteArrayInputStream caInput = new ByteArrayInputStream(CA.caCrt.getBytes(Charset.forName("UTF-8")));
        parser = new PEMParser((Reader)new InputStreamReader(caInput));
        Object object = null;
        try {
            object = parser.readObject();
        }
        catch (IOException e) {
            TXLog.e(TAG, "parse CA failed.", e);
            return null;
        }
        if (!(object instanceof X509CertificateHolder)) {
            TXLog.e(TAG, "CA file not X509CertificateHolder.");
            return null;
        }
        X509CertificateHolder certificateHolder = (X509CertificateHolder)object;
        try {
            ByteArrayInputStream caIn = new ByteArrayInputStream(certificateHolder.getEncoded());
            caCert = (X509Certificate)certFactory.generateCertificate(caIn);
            ((InputStream)caIn).close();
            parser.close();
        }
        catch (Exception e) {
            TXLog.e(TAG, "generate CA certtificate failed.", e);
            return null;
        }
        try {
            KeyStore caKs = KeyStore.getInstance(KeyStore.getDefaultType());
            caKs.load(null, null);
            caKs.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(caKs);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tmf.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            TXLog.e(TAG, "construct SSLSocketFactory failed.", e);
            return null;
        }
    }

    private static PrivateKey getPrivateKey(InputStream stream, String algorithm) throws IOException, GeneralSecurityException {
        PrivateKey key = null;
        boolean isRSAKey = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder builder = new StringBuilder();
        boolean inKey = false;
        String line = br.readLine();
        while (line != null) {
            if (!inKey) {
                if (line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----")) {
                    inKey = true;
                    isRSAKey = line.contains("RSA");
                }
            } else {
                if (line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----")) {
                    inKey = false;
                    isRSAKey = line.contains("RSA");
                    break;
                }
                builder.append(line);
            }
            line = br.readLine();
        }
        KeySpec keySpec = null;
        byte[] encoded = Base64.decode((String)builder.toString(), (int)0);
        keySpec = isRSAKey ? AsymcSslUtils.getRSAKeySpec(encoded) : new PKCS8EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance(algorithm == null ? "RSA" : algorithm);
        key = kf.generatePrivate(keySpec);
        return key;
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        return keySpec;
    }
}

