/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.gateway;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.qcloud.iot_explorer.common.Status;
import com.qcloud.iot_explorer.data_template.TXDataTemplateClient;
import com.qcloud.iot_explorer.data_template.TXDataTemplateDownStreamCallBack;
import com.qcloud.iot_explorer.gateway.TXGatewaySubdev;
import com.qcloud.iot_explorer.mqtt.TXAlarmPingSender;
import com.qcloud.iot_explorer.mqtt.TXMqttActionCallBack;
import com.qcloud.iot_explorer.mqtt.TXMqttConstants;
import com.qcloud.iot_explorer.utils.HmacSha256;
import com.qcloud.iot_explorer.utils.TXLog;
import java.util.HashMap;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TXGatewayClient
extends TXDataTemplateClient {
    public static final String TAG = "TXGATEWAYCLIENT";
    private HashMap<String, TXGatewaySubdev> mSubdevs = new HashMap();
    private static final String GW_OPERATION_RES_PREFIX = "$gateway/operation/result/";
    private static final String GW_OPERATION_PREFIX = "$gateway/operation/";
    private Context mContext;

    public TXGatewayClient(Context context, String serverURI, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack, String jsonFileName, TXDataTemplateDownStreamCallBack downStreamCallBack) {
        super(context, serverURI, productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack, jsonFileName, downStreamCallBack);
        this.mContext = context;
    }

    public TXGatewaySubdev findSubdev(String productId, String devName) {
        Log.d((String)TAG, (String)("input product id is " + productId + ", input device name is " + devName));
        Log.d((String)TAG, (String)("The hashed information is " + this.mSubdevs));
        return this.mSubdevs.get(productId + devName);
    }

    public synchronized TXGatewaySubdev removeSubdev(String productId, String devName) {
        if (null != this.findSubdev(productId, devName)) {
            return this.mSubdevs.remove(productId + devName);
        }
        return null;
    }

    public synchronized TXGatewaySubdev removeSubdev(TXGatewaySubdev subdev) {
        return this.mSubdevs.remove(subdev.mProductId + subdev.mDeviceName);
    }

    public synchronized void addSubdev(TXGatewaySubdev subdev) {
        this.mSubdevs.put(subdev.mProductId + subdev.mDeviceName, subdev);
    }

    public Status subdevOffline(String subProductID, String subDeviceName) {
        Log.d((String)TAG, (String)("Try to find " + subProductID + " & " + subDeviceName));
        TXGatewaySubdev subdev = this.findSubdev(subProductID, subDeviceName);
        if (subdev == null) {
            Log.e((String)TAG, (String)"Cant find the subdev");
            return Status.SUBDEV_STAT_NOT_EXIST;
        }
        if (subdev.getSubdevStatus() == Status.SUBDEV_STAT_OFFLINE) {
            Log.e((String)TAG, (String)"subdev has already offline!");
            return Status.SUBDEV_STAT_OFFLINE;
        }
        String topic = GW_OPERATION_PREFIX + this.mProductId + "/" + this.mDeviceName;
        Log.d((String)TAG, (String)("set " + subProductID + " & " + subDeviceName + " to offline"));
        JSONObject obj = new JSONObject();
        try {
            obj.put("type", (Object)"offline");
            JSONObject plObj = new JSONObject();
            String strDev = "[{'product_id':'" + subProductID + "','device_name':'" + subDeviceName + "'}]";
            JSONArray devs = new JSONArray(strDev);
            plObj.put("devices", (Object)devs);
            obj.put("payload", (Object)plObj);
        }
        catch (JSONException e) {
            return Status.ERROR;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(obj.toString().getBytes());
        Log.d((String)TAG, (String)("publish message " + message));
        return super.publish(topic, message, null);
    }

    public Status subdevOnline(String subProductID, String subDeviceName) {
        TXGatewaySubdev subdev = this.findSubdev(subProductID, subDeviceName);
        if (subdev == null) {
            Log.e((String)TAG, (String)"Cant find the subdev");
            return Status.SUBDEV_STAT_NOT_EXIST;
        }
        if (subdev.getSubdevStatus() == Status.SUBDEV_STAT_ONLINE) {
            Log.e((String)TAG, (String)"subdev has already online!");
            return Status.SUBDEV_STAT_ONLINE;
        }
        String topic = GW_OPERATION_PREFIX + this.mProductId + "/" + this.mDeviceName;
        Log.d((String)TAG, (String)("set " + subProductID + " & " + subDeviceName + " to Online"));
        JSONObject obj = new JSONObject();
        try {
            obj.put("type", (Object)"online");
            JSONObject plObj = new JSONObject();
            String strDev = "[{'product_id':'" + subProductID + "','device_name':'" + subDeviceName + "'}]";
            JSONArray devs = new JSONArray(strDev);
            plObj.put("devices", (Object)devs);
            obj.put("payload", (Object)plObj);
        }
        catch (JSONException e) {
            return Status.ERROR;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(obj.toString().getBytes());
        Log.d((String)TAG, (String)("publish message " + message));
        return super.publish(topic, message, null);
    }

    private boolean consumeGwOperationMsg(String topic, MqttMessage message) {
        if (!topic.startsWith(GW_OPERATION_RES_PREFIX)) {
            return false;
        }
        Log.d((String)TAG, (String)("got gate operation messga " + topic + message));
        try {
            byte[] payload = message.getPayload();
            JSONObject jsonObject = new JSONObject(new String(payload));
            String type = jsonObject.getString("type");
            JSONObject payload_json = jsonObject.getJSONObject("payload");
            JSONArray devices = payload_json.getJSONArray("devices");
            for (int i = 0; i < devices.length(); ++i) {
                String res;
                JSONObject jsonNode = devices.getJSONObject(i);
                TXGatewaySubdev subdev = this.findSubdev(jsonNode.getString("product_id"), jsonNode.getString("device_name"));
                if (null == subdev) {
                    return false;
                }
                if (type.equalsIgnoreCase("online")) {
                    res = jsonNode.getString("result");
                    if (!res.equals("0")) continue;
                    subdev.setSubdevStatus(Status.SUBDEV_STAT_ONLINE);
                    continue;
                }
                if (!type.equalsIgnoreCase("offline") || !(res = jsonNode.getString("result")).equals("0")) continue;
                subdev.setSubdevStatus(Status.SUBDEV_STAT_OFFLINE);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        Log.d((String)TAG, (String)("message received " + topic));
        if (!this.consumeGwOperationMsg(topic, message)) {
            String[] productInfo = topic.split("/");
            String productId = productInfo[3];
            String devName = productInfo[4];
            if (this.mProductId.equals(productId) && this.mDeviceName.equals(devName)) {
                super.messageArrived(topic, message);
            } else {
                TXGatewaySubdev subdev = this.findSubdev(productId, devName);
                if (null != subdev) {
                    subdev.onMessageArrived(topic, message);
                } else {
                    Log.e((String)TAG, (String)("Sub dev should be added! Product id:" + productId + ", Device Name:" + devName));
                }
            }
        }
    }

    @Override
    public synchronized Status connect(MqttConnectOptions options, Object userContext) {
        if (this.mConnectStatus.equals((Object)TXMqttConstants.ConnectStatus.kConnecting)) {
            TXLog.i(TAG, "The client is connecting. Connect return directly.");
            return Status.MQTT_CONNECT_IN_PROGRESS;
        }
        if (this.mConnectStatus.equals((Object)TXMqttConstants.ConnectStatus.kConnected)) {
            TXLog.i(TAG, "The client is already connected. Connect return directly.");
            return Status.OK;
        }
        this.mConnOptions = options;
        if (this.mConnOptions == null) {
            TXLog.e(TAG, "Connect options == null, will not connect.");
            return Status.PARAMETER_INVALID;
        }
        Long timestamp = System.currentTimeMillis() / 1000L + 600L;
        String userNameStr = this.mUserName + ";" + this.getConnectId() + ";" + timestamp;
        this.mConnOptions.setUserName(userNameStr);
        if (this.mSecretKey != null && this.mSecretKey.length() != 0) {
            try {
                Log.d((String)TAG, (String)("secret is " + this.mSecretKey));
                String passWordStr = HmacSha256.getSignature(userNameStr.getBytes(), Base64.decode((String)this.mSecretKey, (int)0)) + ";hmacsha256";
                this.mConnOptions.setPassword(passWordStr.toCharArray());
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)"Failed to set password");
            }
        }
        this.mConnOptions.setMqttVersion(4);
        IMqttActionListener mActionListener = new IMqttActionListener(){

            public void onSuccess(IMqttToken token) {
                TXLog.i(TXGatewayClient.TAG, "onSuccess!");
                TXGatewayClient.this.setConnectingState(TXMqttConstants.ConnectStatus.kConnected);
                TXGatewayClient.this.mActionCallBack.onConnectCompleted(Status.OK, false, token.getUserContext(), "connected to " + TXGatewayClient.this.mServerURI);
                String gwTopic = TXGatewayClient.GW_OPERATION_RES_PREFIX + TXGatewayClient.this.mProductId + "/" + TXGatewayClient.this.mDeviceName;
                int qos = 1;
                TXGatewayClient.this.subscribe(gwTopic, qos, "Subscribe GATEWAY result topic");
                Log.d((String)TXGatewayClient.TAG, (String)"Connected, then subscribe the gateway result topic");
            }

            public void onFailure(IMqttToken token, Throwable exception) {
                TXLog.e(TXGatewayClient.TAG, exception, "onFailure!", new Object[0]);
                TXGatewayClient.this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                TXGatewayClient.this.mActionCallBack.onConnectCompleted(Status.ERROR, false, token.getUserContext(), exception.toString());
            }
        };
        if (this.mMqttClient == null) {
            try {
                this.mPingSender = new TXAlarmPingSender(this.mContext);
                this.mMqttClient = new MqttAsyncClient(this.mServerURI, this.mClientId, this.mMqttPersist, (MqttPingSender)this.mPingSender);
                this.mMqttClient.setCallback((MqttCallback)this);
                this.mMqttClient.setBufferOpts(this.bufferOpts);
                this.mMqttClient.setManualAcks(false);
            }
            catch (Exception e) {
                TXLog.e(TAG, "new MqttClient failed", e);
                this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                return Status.ERROR;
            }
        }
        try {
            TXLog.i(TAG, "Start connecting to %s", this.mServerURI);
            this.setConnectingState(TXMqttConstants.ConnectStatus.kConnecting);
            this.mMqttClient.connect(this.mConnOptions, userContext, mActionListener);
        }
        catch (Exception e) {
            TXLog.e(TAG, "MqttClient connect failed", e);
            this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
            return Status.ERROR;
        }
        return Status.OK;
    }
}

